/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef SCI_EX10_MAXBAUD_SEND_H_
#define SCI_EX10_MAXBAUD_SEND_H_

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"

#if (IS_GS32F00xx(0x12))

#define MY_SCI_BASE 		SCIA_BASE

#if MY_SCI_BASE == SCIA_BASE
#define SCI_TX_GPIO				28
#define SCI_RX_GPIO				29
#define SCI_TX_GPIO_MUX			GPIO_28_SCIA_RX
#define SCI_RX_GPIO_MUX			GPIO_29_SCIA_TX
#elif (MY_SCI_BASE == SCIB_BASE)
#define SCI_TX_GPIO				14
#define SCI_RX_GPIO				15
#define SCI_TX_GPIO_MUX			GPIO_14_SCIB_TX
#define SCI_RX_GPIO_MUX			GPIO_15_SCIB_RX
#endif

#elif IS_GS32F3xx(0x22)

#define MY_SCI_BASE 		SCIB_BASE

#if MY_SCI_BASE == SCIA_BASE
#define SCI_TX_GPIO				42
#define SCI_RX_GPIO				43
#define SCI_TX_GPIO_MUX			GPIO_43_SCIA_RX
#define SCI_RX_GPIO_MUX			GPIO_42_SCIA_RX
#define MY_SCI_INTERRUPT_NUM 	INT_SCIA
#elif (MY_SCI_BASE == SCIB_BASE)
#define SCI_TX_GPIO				14
#define SCI_RX_GPIO				15
#define SCI_TX_GPIO_MUX			GPIO_14_SCIB_TX
#define SCI_RX_GPIO_MUX			GPIO_15_SCIB_RX
#define MY_SCI_INTERRUPT_NUM 	INT_SCIB
#endif

#endif



#define CRC16_POLY		0x1021

#define SEND_DATA_LEN   16
#define RCVE_DATA_LEN	16



void UART_Init(uint32_t SCI_Base,uint32_t baud);
void sci_ex04_rx_irq_TimeOut_Example(uint32_t SCI_base);
void SCIx_INTR_IRQHandler(void);

void UART_Clock_Init();
void UART_GPIO_Init();
void SCI_Init(uint32_t SCIBase,uint32_t baud);
void SCI_Interrupt_Init(uint32_t SCIBase,uint32_t interrupt_numbers);
uint16_t calculate_CRC16(uint8_t *data,uint16_t length);



#endif /* SCI_EX10_MAXBAUD_SEND_H_ */
