/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"
#include "xbar_test.h"

int main(void)
{
	/*init*/
    Device_init();
    UartPrint_init(LOG_SCI_BASE, 115200);

	/*Configure GPIO0 for output direction*/
	GPIO_setDirectionMode(0,GPIO_DIR_MODE_OUT);

	/*Configure GPIO1 as a normal IO*/
	GPIO_setPinConfig(GPIO_1_GPIO1);

	/*GPIO MUX config*/
    GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);
    GPIO_setPinConfig(GPIO_25_OUTPUTXBAR2);
    GPIO_setPinConfig(GPIO_26_OUTPUTXBAR3);
    GPIO_setPinConfig(GPIO_27_OUTPUTXBAR4);
    GPIO_setPinConfig(GPIO_7_OUTPUTXBAR5);
    GPIO_setPinConfig(GPIO_9_OUTPUTXBAR6);
    GPIO_setPinConfig(GPIO_30_OUTPUTXBAR7);
    GPIO_setPinConfig(GPIO_31_OUTPUTXBAR8);
    GPIO_setPinConfig(GPIO_28_OUTPUTXBAR9);
    GPIO_setPinConfig(GPIO_29_OUTPUTXBAR10);
    GPIO_setPinConfig(GPIO_30_OUTPUTXBAR11);
    GPIO_setPinConfig(GPIO_23_OUTPUTXBAR12);

	for(uint32_t i=0;i <= XBAR_OUTPUT8; i++ )
	{

		XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT1,1);
		XBAR_enableOutputMux(OUTPUTXBAR_BASE,i,XBAR_MUX01);
		XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,i,XBAR_OUT_MUX01_INPUTXBAR1);

		/*Cyclic enable outputxbar latch*/
		XBAR_setOutputLatchMode(OUTPUTXBAR_BASE,i,1);

		GPIO_writePin(0,1);
		log_info("OUTPUTXBAR%d  Latch%d\r\n",i+1,XBAR_getOutputLatchStatus(OUTPUTXBAR_BASE, i));
	}


	log_info("xxxxxx\r\n");


	for(uint32_t n=8 ;n <= XBAR_OUTPUT12; n++)
	{

		XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT1,1);
		XBAR_enableOutputMux(OUTPUTXBAR_BASE,n,XBAR_MUX01);
		XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE + 0x100,n,XBAR_OUT_MUX01_INPUTXBAR1);

		XBAR_setOutputLatchMode(OUTPUTXBAR_BASE + 0x100,n,1);

		GPIO_writePin(0,1);
		log_info("OUTPUTXBAR%d  Latch%d\r\n",n+1,XBAR_getOutputLatchStatus(OUTPUTXBAR_BASE + 0x100, n));
	}




    return 0;
}

