/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "load_img.h"
#include "log.h"            //smp thread safe
#include "board_cfg.h"
#include "interrupt.h"

#define LED_PIN             GPIO_PIN_LED1

#define GPIO_INPUT 1
#define GPIO_OUT   2

//0:edge trigger,1:level trigger
#define TEST_CASE 1

volatile uint32_t xint1_count=0;

volatile uint32_t xint3_count=0;

#if TEST_CASE==1

void xint1_fun(void);

void xint1_fun(void)
{
    xint1_count++;
    if (xint1_count<10000) {
    	printf("xint1_count=%d\r\n",xint1_count);
	}else {
	 	xint1_count=0;
	}
}
#else
void xint3_fun(void);

void xint3_fun(void)
{
    xint3_count++;
    if (xint3_count<10000) {
    	printf("xint3_count=%d\r\n",xint3_count);
	}else {
	 	xint3_count=0;
	}
}
#endif
/* Private functions ---------------------------------------------------------*/
/**
  * @brief test inputxbar trigger XINT
  * level trigger:
  * XBAR_INPUT1---->XINT1
  * XBAR_INPUT2---->XINT2
  * edge trigger:
  * XBAR_INPUT3---->XINT3
  * XBAR_INPUT4---->XINT4
  * XBAR_INPUT5---->XINT5
  * XBAR_INPUT6---->XINT6
  * XBAR_INPUT7---->XINT7
  *     .             .
  *     .             .
  *     .             .
  *     .             .
  *     .             .
  *     .             .
  *     .             .
  *     .             .
  *     .             .
  * XBAR_INPUT16--->XINT16
  * @param  None
  * @retval None
  * @note This case takes GPIO1 as input, connects GPIO1 to GPIO2, and GPIO2
  * as output, initially pulls GPIO2 down, and the xbar is configured so that GPIO2 is
  * pulled up, so that the edge trigger only enters the interrupt once, and the level
  * trigger enters the interrupt all the time
  */
int main(void)
{
    uint32_t oldTicks;

    __disable_irq();

    Device_init();

    GPIO_enableWritePin(LED_PIN);
    GPIO_enableWritePin(GPIO_OUT);

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_info("Hello DSP100 Template Project!\r\n");
    log_info("Core running @ %d MHz\r\n", DEVICE_SYSCLK_FREQ/1000/1000);
    log_info("Code @ 0x%08X, Data @ 0x%08X\r\n", (uint32_t)main, (uint32_t)&oldTicks);

#if TEST_CASE==1
    //GPIO1 as input connect XBAR_INPUT1,level trigger
    XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT1 , GPIO_INPUT);
    Interrupt_register(INT_XINT1,xint1_fun);
    Interrupt_enable(INT_XINT1);
#else
    //GPIO1 as input connect XBAR_INPUT6, edge trigger
    XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT3 , GPIO_INPUT);
    Interrupt_register(INT_XINT3,xint3_fun);
    Interrupt_enable(INT_XINT3);
#endif
    __enable_irq();
    DELAY_US(10000);
    GPIO_writePin(GPIO_OUT, 1);


    for(;;);

    return 0;
}


