#include <stdio.h>
#include <stdlib.h>
#include "coremark.h"
#include "core_portme.h"
//#include "tinv_demo_arm.h"
//#include "platform.h"
#include "config.h"
//#include "encoding.h"
#include "board_cfg.h"

#define DSP_CORE	1
#define ARM_CORE	2

#ifndef CORE_TYPE
#define CORE_TYPE DSP_CORE
#endif

#include "GS32F00xx.h"

#if VALIDATION_RUN
	volatile ee_s32 seed1_volatile=0x3415;
	volatile ee_s32 seed2_volatile=0x3415;
	volatile ee_s32 seed3_volatile=0x66;
#endif

#if PERFORMANCE_RUN
	volatile ee_s32 seed1_volatile=0x0;
	volatile ee_s32 seed2_volatile=0x0;
	volatile ee_s32 seed3_volatile=0x66;
#endif

#if PROFILE_RUN
	volatile ee_s32 seed1_volatile=0x8;
	volatile ee_s32 seed2_volatile=0x8;
	volatile ee_s32 seed3_volatile=0x8;
#endif

volatile ee_s32 seed4_volatile=ITERATIONS;
volatile ee_s32 seed5_volatile=0;

static CORE_TICKS t0, t1;

extern CORE_TICKS get_timer_value(void);

#ifdef CFG_DEBUG
	unsigned long long rdmcycle(void)
	{
		#if __riscv_xlen == 32
		do {
				unsigned long hi = read_csr(mcycleh);
				unsigned long lo = read_csr(mcycle);

				if (hi == read_csr(mcycleh))
					return ((unsigned long long)hi << 32) | lo;
		} while(1);
		#else
			return (unsigned long long)read_csr(mcycle);
		#endif
	}

	unsigned long long rdminstret(void)
	{
		#if __riscv_xlen == 32
		do {
				unsigned long hi = read_csr(CSR_MINSTRETH);
				unsigned long lo = read_csr(CSR_MINSTRET);

				if (hi == read_csr(CSR_MINSTRETH))
					return ((unsigned long long)hi << 32) | lo;
		} while(1);
		#else
			return (unsigned long long)read_csr(CSR_MINSTRET);
		#endif
	}

#endif

#if 0
void start_time(void)
{
#ifdef CFG_MTIME
	printf("\nThe time is from mtime\n");
#else
	printf("\nThe time is from mcycle\n");
#endif
	t0 = get_timer_value();

#ifdef CFG_DEBUG
	printf("The current mcycle value of benchmark are:%u \n",(unsigned int)rdmcycle());
	printf("The current minstreth value of benchmark are:%u \n",(unsigned int)rdminstret());
#endif

}

void stop_time(void)
{
	t1 = get_timer_value();

	#ifdef CFG_DEBUG
		printf("The current mcycle value of benchmark are:%u \n",(unsigned int)rdmcycle());
		printf("The current minstreth value of benchmark are:%u \n",(unsigned int)rdminstret());
	#endif

}

CORE_TICKS get_time(void)
{
	return (CORE_TICKS)t1 - t0;
}

secs_ret time_in_secs(CORE_TICKS ticks)
{
	extern unsigned int get_timer_freq();

	secs_ret delta = (secs_ret)ticks;
	secs_ret freq = (secs_ret)get_timer_freq();
	secs_ret val=delta / freq;
	return val;
}
#endif

static CORE_TICKS t0, t1;
//typedef float secs_ret;
extern volatile uint32_t SystemCoreClock;


CORE_TICKS gTick;


void start_time(void)
{
#if CORE_TYPE == DSP_CORE
	t0 = __get_rv_cycle();
#elif CORE_TYPE == TI_CORE
	t0 = 
#elif CORE_TYPE == ARM_CORE
	//	  gTick = 0; 
	//	  SysTick_Config(((SystemCoreClock / 8) /1000)); //core_clk/8, is sys_tick_clk. then /1000 = 1ms
	t0 = *(CORE_TICKS *)0xE0001004; 
#endif
}

void stop_time(void)
{
#if CORE_TYPE == DSP_CORE
	t1 = __get_rv_cycle();
#elif CORE_TYPE == TI_CORE
	t1 = 0;
#elif CORE_TYPE == ARM_CORE
	//	   SysTick->CTRL &= 0xFFFFFFFE;
	t1 = *(CORE_TICKS *)0xE0001004; 
#endif
}

CORE_TICKS get_time(void)
{
#if CORE_TYPE == DSP_CORE
	return t1 - t0;
#elif CORE_TYPE == TI_CORE
	return 0;
#elif CORE_TYPE == ARM_CORE
	//	  return (CORE_TICKS)gTick;
	return t1 - t0;
#endif  		
}

secs_ret time_in_secs(CORE_TICKS ticks)
{
#if CORE_TYPE == DSP_CORE
	// scale timer down to avoid uint64_t -> double conversion in RV32
	#if 0
		int scale = 256;
		uint64_t delta = ticks / scale;
		uint64_t freq = SystemCoreClock / scale;
		return delta / (double)freq;
	#else
		return ticks / (float)(DEVICE_SYSCLK_FREQ);
	#endif

#elif CORE_TYPE == TI_CORE
	return 0;
#elif CORE_TYPE == ARM_CORE
	//secs_ret retval = ((secs_ret)ticks) / (secs_ret)EE_TICKS_PER_SEC;
	//	  secs_ret retval = ((secs_ret)ticks) / 1000;
	//    return retval;
	uint64_t freq = 20000000;
	return ticks / (double)freq;
#endif    	
}

void portable_init(core_portable *p, int *argc, char *argv[]){
	return;
}
void portable_fini(core_portable *p){
	return;
}

uint32_t get_timer_freq(void){
	return DEVICE_SYSCLK_FREQ;
}

CORE_TICKS get_timer_value(void){
	return 0;
}

