/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    clb_ex1_combinatorial_logic.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include <board.h>
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */
uint16_t dutyValue=200;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

// Board Configurations
void Board_init()
{
	PinMux_init();
	CLBOUTPUTXBAR_init();
	INTERRUPT_init();
	myTILE1_init();
	pwm_set();
	CLB_enableCLB(myTILE1_BASE);

}

// PINMUX Configurations
void PinMux_init()
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_0_EPWM1_A);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(0, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_1_EPWM1_B);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_SYNC);


	//
	// EPWM2 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_2_EPWM2_A);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);



	//OUTPUTXBAR1
	GPIO_setPinConfig(GPIO_22_CLB_OUTPUTXBAR1);
	GPIO_setPadConfig(22, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(22, GPIO_QUAL_SYNC);
	//OUTPUTXBAR2
	GPIO_setPinConfig(GPIO_23_CLB_OUTPUTXBAR3);
	GPIO_setPadConfig(23, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(23, GPIO_QUAL_SYNC);


	//gpio30
	GPIO_setPinConfig(GPIO_10_GPIO10);
	GPIO_setPadConfig(10, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(10, GPIO_QUAL_SYNC);

	GPIO_enableWritePin(10);

}

void myTILE1_init(){

	initTILE0(myTILE1_BASE);

	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN0, CLB_GP_IN_MUX_GP_REG);

	CLB_selectInputFilter(myTILE1_BASE, CLB_IN0, CLB_FILTER_NONE);
	//
	// myTILE1 CLB_IN2 initialization
	//
	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN2, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN2, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myTILE1_BASE, CLB_IN2, CLB_FILTER_NONE);
	//
	// myTILE1 CLB_IN3 initialization
	//
	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN3, CLB_GLOBAL_IN_MUX_EPWM1B);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN3, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myTILE1_BASE, CLB_IN3, CLB_FILTER_NONE);
	CLB_setGPREG(myTILE1_BASE,0);
	CLB_enableCLB(myTILE1_BASE);
	CLB_setOutputMask(myTILE1_BASE, 0x5, true);
}


void pwm_set()
{
	 SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
	//
	// Set phase shift to 0 and clear the time base counter
	//
	EPWM_setPhaseShift(myEPWM1_BASE, 0);
	EPWM_setTimeBaseCounter(myEPWM1_BASE, 0);

	//
	// Disable the shadow load; the load will be immediate instead
	//
	EPWM_disableCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A);
	EPWM_disableCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B);

	//
	// Set the compare A value to half the period value, compare B to 0
	//
	EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, 1000);
	EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, 500);

	// Setup action qualifier
	EPWM_setActionQualifierActionComplete(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH_UP_CMPA | EPWM_AQ_OUTPUT_LOW_PERIOD);
	EPWM_setActionQualifierActionComplete(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH_UP_CMPB | EPWM_AQ_OUTPUT_LOW_PERIOD);

	//
	// Enable interrupt when the counter is equal to 0
	//
	EPWM_setInterruptSource(myEPWM1_BASE, EPWM_INT_TBCTR_ZERO);
	EPWM_enableInterrupt(myEPWM1_BASE);

	//
	// Interrupt on first event
	//
	EPWM_setInterruptEventCount(myEPWM1_BASE, 1);

	//
	// Set the time base clock prescaler to /1
	//
	EPWM_setClockPrescaler(myEPWM1_BASE, EPWM_CLOCK_DIVIDER_1,
						   EPWM_HSCLOCK_DIVIDER_1);

	//
	// Set the period value; don't shadow the register
	//
	EPWM_setPeriodLoadMode(myEPWM1_BASE, EPWM_PERIOD_DIRECT_LOAD);
	EPWM_setTimeBasePeriod(myEPWM1_BASE, 2000);

	//
	// Put the time base counter into up-down count mode
	//
	EPWM_setTimeBaseCounterMode(myEPWM1_BASE, EPWM_COUNTER_MODE_UP);

	//
	// Sync the ePWM time base clock
	//
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
}


void CLBOUTPUTXBAR_init()
{
	XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX04_CLB1_OUT4);
	XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX04);

	XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT3,XBAR_OUT_MUX05_CLB1_OUT5);
	XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT3,XBAR_MUX05);

	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX32_CLB1_OUT0);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX32);

}


void INTERRUPT_init()
{

   	Interrupt_register(INT_CLB1 , &clb1ISR);
   	Interrupt_enable(INT_CLB1 );

}


void clb1ISR(void)
{
	 uint32_t intTag = CLB_getInterruptTag(myTILE1_BASE);

	   if (intTag == 1)
	   {
	       //
	       // Match 1 value EQUAL
	       //
	       ESTOP0;
	   }
	   else if (intTag == 2)
	   {
	       //
	       // Match 2 TAP Select Bit Set
	       //
	       ESTOP0;
	   }


    CLB_clearInterruptTag(myTILE1_BASE);
}


/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief description of this function
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif

