/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    qeqp_test04_Reset_on_Index_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include <board.h>
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */
uint16_t dutyValue=200;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

// Board Configurations
void Board_init()
{
	PinMux_init();
	CLBOUTPUTXBAR_init();
	INTERRUPT_init();
	myTILE1_init();
	pwm_set();
	CLB_enableCLB(myTILE1_BASE);

}

// PINMUX Configurations
void PinMux_init()
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_0_EPWM1_A);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(0, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_1_EPWM1_B);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_SYNC);


	//
	// EPWM2 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_2_EPWM2_A);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);



	//OUTPUTXBAR1
	GPIO_setPinConfig(GPIO_22_CLB_OUTPUTXBAR1);
	GPIO_setPadConfig(22, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(22, GPIO_QUAL_SYNC);
	//CLBOUTPUTXBAR3
	GPIO_setPinConfig(GPIO_23_CLB_OUTPUTXBAR3);
	GPIO_setPadConfig(23, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(23, GPIO_QUAL_SYNC);


	//gpio30
	GPIO_setPinConfig(GPIO_10_GPIO10);
	GPIO_setPadConfig(10, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(10, GPIO_QUAL_SYNC);

	GPIO_enableWritePin(10);

}

void myTILE1_init(){


	initTILE1(myTILE1_BASE);
	//
	// myTILE1 CLB_IN0 initialization
	//
	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN0, CLB_GP_IN_MUX_GP_REG);

	CLB_selectInputFilter(myTILE1_BASE, CLB_IN0, CLB_FILTER_NONE);

	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN1, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN1, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myTILE1_BASE, CLB_IN1, CLB_FILTER_NONE);
	CLB_setGPREG(myTILE1_BASE,0);
	CLB_setOutputMask(myTILE1_BASE, 0x1, true);
}


void pwm_set()
{
	  //
	    // Disable the ePWM time base clock before configuring the module
	    //
	    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

	    //
	    // Set phase shift to 0 and clear the time base counter
	    //
	    EPWM_setPhaseShift(EPWM1_BASE, 0);
	    EPWM_setTimeBaseCounter(EPWM1_BASE, 0);

	    //
	    // Disable the shadow load; the load will be immediate instead
	    //
	    EPWM_disableCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_A);
	    EPWM_disableCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_B);

	    //
	    // Set the compare A value to half the period value, compare B to 0
	    //
	    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 10);
	    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, 50);

	    // Setup action qualifier
	    EPWM_setActionQualifierActionComplete(EPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH_UP_CMPA | EPWM_AQ_OUTPUT_LOW_PERIOD);
	    EPWM_setActionQualifierActionComplete(EPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH_UP_CMPB | EPWM_AQ_OUTPUT_LOW_PERIOD);

	    //
	    // Enable interrupt when the counter is equal to 0
	    //
	    EPWM_setInterruptSource(EPWM1_BASE, EPWM_INT_TBCTR_ZERO);
	    EPWM_enableInterrupt(EPWM1_BASE);

	    //
	    // Interrupt on first event
	    //
	    EPWM_setInterruptEventCount(EPWM1_BASE, 1);

	    //
	    // Set the time base clock prescaler to /1
	    //
	    EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1,
	                           EPWM_HSCLOCK_DIVIDER_1);

	    //
	    // Set the period value; don't shadow the register
	    //
	    EPWM_setPeriodLoadMode(EPWM1_BASE, EPWM_PERIOD_DIRECT_LOAD);
	    EPWM_setTimeBasePeriod(EPWM1_BASE, 1000);

	    //
	    // Put the time base counter into up-down count mode
	    //
	    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);

	    //
	    // Sync the ePWM time base clock
	    //
	    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
	}



void CLBOUTPUTXBAR_init()
{
	XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX04_CLB1_OUT4);
	XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX04);

	XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT3,XBAR_OUT_MUX02_CLB1_OUT2);
	XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT3,XBAR_MUX02);

	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX32_CLB1_OUT0);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX32);

}


void INTERRUPT_init()
{


	Interrupt_register(INT_CLB1 ,clb1ISR);
	Interrupt_enable(INT_CLB1 );

}


void clb1ISR(void)
{
         // Debug: Used to determine if interrupt is being set

    //
    // Change duty cycle of PWM signal at the end of a period
    //
    if (dutyValue == 150)
    {
        dutyValue = 100U;
    }
    else
    {
        dutyValue = 150U;
    }

    //
    // Load new duty cycle value in HLC Registers
    //
    CLB_setHLCRegisters(myTILE1_BASE, dutyValue, 0, 0, 0);

    CLB_clearInterruptTag(myTILE1_BASE);
}
/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

/**
 * \brief   add brief description of this function
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif

