/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef GPIO_EX1_SETUP_H
#define GPIO_EX1_SETUP_H

/*
 * @brief If building with a C++ compiler, make all of the definitions
 * 		  in this header have a C binding.
 */
#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief Configuration of the GPIO
 */
#if (GS32_PART_NUM == 0x0039A)

#define OUT_GPIO_PIN          8
#define OUT_GPIO_CFG          GPIO_8_GPIO8

#define INPUT_GPIO_PIN        34
#define INPUT_GPIO_CFG        GPIO_34_GPIO34

#define INPUT_PERIOD_GPIO_PIN 24
#define INPUT_PERIOD_GPIO_CFG GPIO_24_GPIO24

#define INPUT_XINT_GPIO_PIN   26
#define INPUT_XINT_GPIO_CFG   GPIO_26_GPIO26

#define PWM_A_GPIO_PIN        0
#define PWM_A_GPIO_CFG        GPIO_0_EPWM1_A
#define PWM_B_GPIO_PIN        1
#define PWM_B_GPIO_CFG        GPIO_1_EPWM1_B

#define ECAP_GPIO_PIN         7

#define TZ_GPIO_PIN           12

#define SPI_SIMO_GPIO_PIN     16
#define SPI_SIMO_GPIO_CFG     GPIO_16_SPIA_SIMO
#define SPI_SOMI_GPIO_PIN     17
#define SPI_SOMI_GPIO_CFG     GPIO_17_SPIA_SOMI
#define SPI_CLK_GPIO_PIN      18
#define SPI_CLK_GPIO_CFG      GPIO_18_SPIA_CLK
#define SPI_STE_GPIO_PIN      19
#define SPI_STE_GPIO_CFG      GPIO_19_SPIA_STE

#define EQEP_A_GPIO_PIN       25
#define EQEP_A_GPIO_CFG       GPIO_25_EQEP1_A
#define EQEP_B_GPIO_PIN       29
#define EQEP_B_GPIO_CFG       GPIO_29_EQEP1_B
#define EQEP_STROBE_GPIO_PIN  22
#define EQEP_STROBE_GPIO_CFG  GPIO_22_EQEP1_STROBE
#define EQEP_INDEX_GPIO_PIN   23
#define EQEP_INDEX_GPIO_CFG   GPIO_23_EQEP1_INDEX

#define SCI_TX_GPIO_PIN       29
#define SCI_TX_GPIO_CFG       GPIO_29_SCIA_TX
#define SCI_RX_GPIO_PIN       28
#define SCI_RX_GPIO_CFG       GPIO_28_SCIA_RX

#define CAN_TX_GPIO_PIN       31
#define CAN_TX_GPIO_CFG       GPIO_31_CANA_TX
#define CAN_RX_GPIO_PIN       30
#define CAN_RX_GPIO_CFG       GPIO_30_CANA_RX

#define IIC_SDA_GPIO_PIN      32
#define IIC_SDA_GPIO_CFG      GPIO_32_I2CA_SDA
#define IIC_SCL_GPIO_PIN      33
#define IIC_SCL_GPIO_CFG      GPIO_33_I2CA_SCL

#endif

#endif // GPIO_EX1_SETUP_H
