/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "gpio_ex1_setup.h"
#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

//
// @brief  GPIO setup.
//
void setupGPIO(void);

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/*
 * @brief  main function.
 */
int main(void)
{
    /* Initialize device */
    Device_init();

    /* This example is a basic pinout */
    setupGPIO();

    /* Loop */
    while (1) {
    }

    /* This line will never be reached */
    return 0;
}

//
// setupGPIO - Is an example that demonstrates the basic pinout
//
void setupGPIO(void)
{
    /* Example: Basic Pinout.
     * This basic pinout includes:
     * PWM1, ECAP1, SPI-A, EQEP1, SCI-A, CAN-A, I2C
     * and a number of I/O pins
     * These can be combined into single statements for improved
     * code efficiency.
     */

    /* Enable a GPIO output, set it high */
    GPIO_setPadConfig(OUT_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);  /* Enable pullup */
    GPIO_writePin(OUT_GPIO_PIN, 1);                         /* Load output latch */
    GPIO_setPinConfig(OUT_GPIO_CFG);                        /* OUT_GPIO_PIN = GPIO */
    GPIO_setDirectionMode(OUT_GPIO_PIN, GPIO_DIR_MODE_OUT); /* OUT_GPIO_PIN = output */

    /* Make INPUT_GPIO_PIN an input */
    GPIO_setPadConfig(INPUT_GPIO_PIN, GPIO_PIN_TYPE_PULLUP); /* Enable pullup */
    GPIO_setPinConfig(INPUT_GPIO_CFG);                       /* INPUT_GPIO_CFG = GPIO */
    GPIO_setDirectionMode(INPUT_GPIO_PIN, GPIO_DIR_MODE_IN); /* INPUT_GPIO_CFG = input */

    /* Set input qualification period */
    GPIO_setQualificationPeriod(INPUT_PERIOD_GPIO_PIN, 2);               /* Qual period=SYSCLKOUT/2 */
    GPIO_setQualificationMode(INPUT_PERIOD_GPIO_PIN, GPIO_QUAL_6SAMPLE); /* 6 samples */

    /* Make INPUT_XINT_GPIO_PIN the input source for XINT1 */
    GPIO_setPinConfig(INPUT_XINT_GPIO_CFG);                       /* INPUT_XINT_GPIO_PIN = GPIO */
    GPIO_setDirectionMode(INPUT_XINT_GPIO_PIN, GPIO_DIR_MODE_IN); /* INPUT_XINT_GPIO_PIN = input */
    GPIO_setInterruptPin(INPUT_XINT_GPIO_PIN, GPIO_INT_XINT1);    /* XINT1 connected to INPUT_XINT_GPIO_PIN */

    /* Enable PWM1 on PWM_A_GPIO_PIN-PWM_B_GPIO_PIN */
    GPIO_setPadConfig(PWM_A_GPIO_PIN, GPIO_PIN_TYPE_PULLUP); /* Enable pullup on PWM_A_GPIO_PIN */
    GPIO_setPadConfig(PWM_B_GPIO_PIN, GPIO_PIN_TYPE_PULLUP); /* Enable pullup on PWM_B_GPIO_PIN */
    GPIO_setPinConfig(PWM_A_GPIO_CFG);                       /* PWM_A_GPIO_PIN = PWM1A */
    GPIO_setPinConfig(PWM_B_GPIO_CFG);                       /* PWM_B_GPIO_PIN = PWM1B */

    /* Enable eCAP1 on ECAP_GPIO_PIN */
    GPIO_setPadConfig(ECAP_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);       /* Enable pullup */
    GPIO_setQualificationMode(ECAP_GPIO_PIN, GPIO_QUAL_SYNC);     /* Synch to SYSCLKOUT */
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT7, ECAP_GPIO_PIN); /* ECAP_GPIO_PIN = ECAP1 */

    /* Enable Trip Zone inputs on TZ_GPIO_PIN */
    GPIO_setPadConfig(TZ_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);       /* Enable pullup */
    GPIO_setQualificationMode(TZ_GPIO_PIN, GPIO_QUAL_ASYNC);    /* asynch input */
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, TZ_GPIO_PIN); /* TZ_GPIO_PIN = TZ1 */

    /* Enable SPI-A on SPI_SIMO_GPIO_PIN - SPI_STE_GPIO_PIN */
    GPIO_setPadConfig(SPI_SIMO_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Pullup SPI_SIMO_GPIO_PIN */
    GPIO_setPadConfig(SPI_SOMI_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Pullup SPI_SOMI_GPIO_PIN */
    GPIO_setPadConfig(SPI_CLK_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);     /* Pullup SPI_CLK_GPIO_PIN */
    GPIO_setPadConfig(SPI_STE_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);     /* Pullup SPI_STE_GPIO_PIN */
    GPIO_setQualificationMode(SPI_SIMO_GPIO_PIN, GPIO_QUAL_ASYNC); /* asynch input */
    GPIO_setQualificationMode(SPI_SOMI_GPIO_PIN, GPIO_QUAL_ASYNC); /* asynch input */
    GPIO_setQualificationMode(SPI_CLK_GPIO_PIN, GPIO_QUAL_ASYNC);  /* asynch input */
    GPIO_setQualificationMode(SPI_STE_GPIO_PIN, GPIO_QUAL_ASYNC);  /* asynch input */
    GPIO_setPinConfig(SPI_SIMO_GPIO_CFG);                          /* SPI_SIMO_GPIO_PIN = SPISIMOA */
    GPIO_setPinConfig(SPI_SOMI_GPIO_CFG);                          /* SPI_SOMI_GPIO_PIN = SPIS0MIA */
    GPIO_setPinConfig(SPI_CLK_GPIO_CFG);                           /* SPI_CLK_GPIO_PIN = SPICLKA */
    GPIO_setPinConfig(SPI_STE_GPIO_CFG);                           /* SPI_STE_GPIO_PIN = SPISTEA */

    /* Enable EQEP1 on GPIO's EQEP_A_GPIO_PIN,EQEP_B_GPIO_PIN,EQEP_STROBE_GPIO_PIN,EQEP_INDEX_GPIO_PIN */
    GPIO_setPadConfig(EQEP_A_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);        /* Enable pullup on EQEP_A_GPIO_PIN */
    GPIO_setPadConfig(EQEP_B_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);        /* Enable pullup on EQEP_B_GPIO_PIN */
    GPIO_setPadConfig(EQEP_STROBE_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);   /* Enable pullup on EQEP_STROBE_GPIO_PIN */
    GPIO_setPadConfig(EQEP_INDEX_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Enable pullup on EQEP_INDEX_GPIO_PIN */
    GPIO_setQualificationMode(EQEP_A_GPIO_PIN, GPIO_QUAL_SYNC);      /* Synch to SYSCLKOUT */
    GPIO_setQualificationMode(EQEP_B_GPIO_PIN, GPIO_QUAL_SYNC);      /* Synch to SYSCLKOUT */
    GPIO_setQualificationMode(EQEP_STROBE_GPIO_PIN, GPIO_QUAL_SYNC); /* Synch to SYSCLKOUT */
    GPIO_setQualificationMode(EQEP_INDEX_GPIO_PIN, GPIO_QUAL_SYNC);  /* Synch to SYSCLKOUT */
    GPIO_setPinConfig(EQEP_A_GPIO_CFG);                              /* EQEP_A_GPIO_PIN = EQEP1A */
    GPIO_setPinConfig(EQEP_B_GPIO_CFG);                              /* EQEP_B_GPIO_PIN = EQEP1B */
    GPIO_setPinConfig(EQEP_STROBE_GPIO_CFG);                         /* EQEP_STROBE_GPIO_PIN = EQEP1S */
    GPIO_setPinConfig(EQEP_INDEX_GPIO_CFG);                          /* EQEP_INDEX_GPIO_PIN = EQEP1I */

    /* Enable SCI-A on SCI_RX_GPIO_PIN - SCI_TX_GPIO_PIN */
    GPIO_setPadConfig(SCI_RX_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Enable pullup on SCI_RX_GPIO_PIN */
    GPIO_setQualificationMode(SCI_RX_GPIO_PIN, GPIO_QUAL_ASYNC); /* asynch input */
    GPIO_setPinConfig(SCI_RX_GPIO_CFG);                          /* SCI_RX_GPIO_PIN = SCIRXDA */
    GPIO_setPadConfig(SCI_TX_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Enable pullup on SCI_TX_GPIO_PIN */
    GPIO_setPinConfig(SCI_TX_GPIO_CFG);                          /* SCI_TX_GPIO_PIN = SCITXDA */

    /* Enable CAN-A on CAN_RX_GPIO_PIN - CAN_TX_GPIO_CFG */
    GPIO_setPadConfig(CAN_RX_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Enable pullup on CAN_RX_GPIO_PIN */
    GPIO_setQualificationMode(CAN_RX_GPIO_PIN, GPIO_QUAL_ASYNC); /* asynch input */
    GPIO_setPinConfig(CAN_RX_GPIO_CFG);                          /* CAN_RX_GPIO_PIN = CANRXA */
    GPIO_setPadConfig(CAN_TX_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Enable pullup on CAN_TX_GPIO_CFG */
    GPIO_setPinConfig(CAN_TX_GPIO_CFG);                          /* CAN_TX_GPIO_CFG = CANTXA */

    /* Enable I2C-A on IIC_SDA_GPIO_PIN - IIC_SDA_GPIO_PIN */
    GPIO_setPadConfig(IIC_SDA_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Enable pullup on IIC_SDA_GPIO_PIN */
    GPIO_setPinConfig(IIC_SDA_GPIO_CFG);                          /* IIC_SDA_GPIO_PIN = SDAA */
    GPIO_setQualificationMode(IIC_SDA_GPIO_PIN, GPIO_QUAL_ASYNC); /* asynch input */
    GPIO_setPadConfig(IIC_SCL_GPIO_PIN, GPIO_PIN_TYPE_PULLUP);    /* Enable pullup on IIC_SDA_GPIO_PIN */
    GPIO_setQualificationMode(IIC_SCL_GPIO_PIN, GPIO_QUAL_ASYNC); /* asynch input */
    GPIO_setPinConfig(IIC_SCL_GPIO_CFG);                          /* IIC_SDA_GPIO_PIN = SCLA */
}
