/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef GPIO_EX3_INTERRUPT_H
#define GPIO_EX3_INTERRUPT_H

/*
 * @brief If building with a C++ compiler, make all of the definitions
 * 		  in this header have a C binding.
 */
#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief Configuration of the GPIO
 */
#if (GS32_PART_NUM == 0x0039A)

#define myGPIOInputInterrupt0 			28
#define myGPIOInputInterrupt0_CONFIG 	GPIO_28_GPIO28

#define myGPIOOutput0 					22U
#define myGPIOOutput0_CONFIG 			GPIO_22_GPIO22

#define myGPIOOutput1 					20U
#define myGPIOOutput1_CONFIG 			GPIO_20_GPIO20

#endif

#endif // GPIO_EX3_INTERRUPT_H
