/*
 * 	File: hrpwm_ex02_duty_updown_sfo_Extend
 *
 *	ʾUP_DownģʽHRPWMĸ߾ռձȿЧ
 *
 *  ePWM1ePWM2ʹõԶģʽePWM3ePWM4ʹֶģʽ
 *
 *  ʾePWM1A ->IO0ePWM1B->IO1۲첨
 *  ʾePWM2A ->IO2ePWM2B->IO3۲첨
 *  ʾePWM3A ->IO4ePWM3B->IO5۲첨
 *  ʾePWM4A ->IO6ePWM4B->IO7۲첨
 *
 *	duty_ePWMx   -> ռձ
 *	EPWM_TIMER_UO_DOWN_TBPRD	->  ֵ
 *
 *
 *	ͨ IDE  duty_ePWMx,Ȼ ePWMx_Controlsx Ϊ 1 ݸ
 *
 *
 *
 *
*/
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "hrpwm_ex02_board.h"
#include "SFO_v2.h"



#define EPWM_TIMER_UO_DOWN_TBPRD       100UL

//SFO״̬
SFO_Status_t SFO_Status;
//SFOϢ
SFO_Params_t SFO_Params;

//ePWM1λ
volatile uint8_t ePWM1_Controls = 1;
//ePWM2λ
volatile uint8_t ePWM2_Controls = 1;
//ePWM3λ
volatile uint8_t ePWM3_Controls = 1;
//ePWM4λ
volatile uint8_t ePWM4_Controls = 1;

void error (void);

void HRPWM_Update_HrDuty_Center(uint32_t Epwmbase,HRPWM_CounterCompareModule channel,uint32_t period,float32_t duty);

const float duty = 45.0f;

//ePMW1ռձ
volatile float duty_ePWM1 = duty;
//ePMW2ռձ
volatile float duty_ePWM2 = duty;
//ePMW3ռձ
volatile float duty_ePWM3 = duty;
//ePMW4ռձ
volatile float duty_ePWM4 = duty;

int main(void)
{
    //
    // Initialize device clock and peripherals
    //
    Device_init();


    //
    // Calling SFO() updates the HRMSTEP register with calibrated MEP_ScaleFactor.
    // HRMSTEP must be populated with a scale factor value prior to enabling
    // high resolution period control.
    //
    SFO_Struct_init(&SFO_Params,5);

    do
    {
    	SFO_Status = SFO(&SFO_Params);

        if(SFO_Success != SFO_Status)
        {
            error();   	//Look at the enumeration type to see the error type
        }
    }while(SFO_Status != SFO_Success);



    //
    // Disable sync(Freeze clock to PWM as well)
    //
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


    //
    // Initialize the EPWM GPIO Pins and change the XBAR inputs from using GPIO0
    //
    Board_init();

    //
    // Enable sync and clock to PWM
    //
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;

    while (1)
    {

    	SFO_Status = SFO(&SFO_Params);


    	if( ePWM1_Controls == 1 )    	// Auto
    	{

    		ePWM1_Controls = 0;

    		HRPWM_Update_HrDuty_Center(myEPWM1_BASE,HRPWM_COUNTER_COMPARE_A,EPWM_TIMER_UO_DOWN_TBPRD,(EPWM_TIMER_UO_DOWN_TBPRD - duty_ePWM1));

    		//	Ҫ۲ B ͨĲα仯ע͵ A ƵĴ벢ȡעB ͨĴ
    		//HRPWM_Update_HrDuty_Center(myEPWM1_BASE,HRPWM_COUNTER_COMPARE_B,100,(100 - duty_ePWM1));


    	}else if( ePWM2_Controls == 1 )    	// Auto
    	{

    		ePWM2_Controls = 0;

    		HRPWM_Update_HrDuty_Center(myEPWM2_BASE,HRPWM_COUNTER_COMPARE_A,EPWM_TIMER_UO_DOWN_TBPRD,(EPWM_TIMER_UO_DOWN_TBPRD - duty_ePWM2));

    		//	Ҫ۲ B ͨĲα仯ע͵ A ƵĴ벢ȡעB ͨĴ
    		//HRPWM_Update_HrDuty_Center(myEPWM2_BASE,HRPWM_COUNTER_COMPARE_B,EPWM_TIMER_UO_DOWN_TBPRD,(100 - duty_ePWM2));

    	}else if( ePWM3_Controls == 1 )    	// Not Auto
    	{

    		ePWM3_Controls = 0;

    		HRPWM_Update_HrDuty_Center(myEPWM3_BASE,HRPWM_COUNTER_COMPARE_A,EPWM_TIMER_UO_DOWN_TBPRD,(EPWM_TIMER_UO_DOWN_TBPRD - duty_ePWM3));

    		//	Ҫ۲ B ͨĲα仯ע͵ A ƵĴ벢ȡעB ͨĴ
    		//HRPWM_Update_HrDuty_Center(myEPWM3_BASE,HRPWM_COUNTER_COMPARE_B,EPWM_TIMER_UO_DOWN_TBPRD,(100 - duty_ePWM3));

    	}else if( ePWM4_Controls == 1 )    	// Not Auto
    	{

    		ePWM4_Controls = 0;

    		HRPWM_Update_HrDuty_Center(myEPWM4_BASE,HRPWM_COUNTER_COMPARE_A,EPWM_TIMER_UO_DOWN_TBPRD,(EPWM_TIMER_UO_DOWN_TBPRD - duty_ePWM4));

    		//	Ҫ۲ B ͨĲα仯ע͵ A ƵĴ벢ȡעB ͨĴ
    		//HRPWM_Update_HrDuty_Center(myEPWM4_BASE,HRPWM_COUNTER_COMPARE_B,EPWM_TIMER_UO_DOWN_TBPRD,(100 - duty_ePWM4));
    	}

    }

    return 0;
}


//
// error - Halt debugger when called
//
void error (void)
{
    ESTOP0;         // Stop here and handle error
}




void HRPWM_Update_HrDuty_Center(uint32_t Epwmbase,HRPWM_CounterCompareModule channel,uint32_t period,float32_t duty)
{
	uint16_t  Hrstep = 0;
	uint16_t  SetCMPA_A1 = 0 ,SetCMPHRA_A1 = 0;
	uint16_t  SetCMPB_B1 = 0 ,SetCMPHRB_B1 = 0;
	uint16_t  HR_mstep = 0;
	uint8_t   Auto_Flag = 0;


	Auto_Flag = HWREGH(Epwmbase + HRPWM_O_HRCNFG) & HRPWM_HRCNFG_AUTOCONV;

	if(Auto_Flag)
	{
		HR_mstep = 256U;

	}else
	{
		HR_mstep = HWREGB(Epwmbase + HRPWM_O_HRMSTEP);
	}

	SetCMPA_A1   = (uint16_t)(duty/100.0f*period);
	SetCMPHRA_A1 = (uint16_t)((duty/100.0f*period - SetCMPA_A1) * HR_mstep + 0.5);

	SetCMPB_B1   = SetCMPA_A1+1;
	SetCMPHRB_B1 = HR_mstep - SetCMPHRA_A1;

	if(!(SetCMPHRB_B1%HR_mstep))
	{
		SetCMPHRB_B1 -= 1;
	}
	if( HRPWM_COUNTER_COMPARE_A == channel )
	{
		HRPWM_setCounterCompareValue(Epwmbase,HRPWM_COUNTER_COMPARE_A,(SetCMPA_A1<<8)|SetCMPHRA_A1);
		HRPWM_setCounterCompareValue(Epwmbase,HRPWM_COUNTER_COMPARE_B,(SetCMPB_B1<<8)|SetCMPHRB_B1);

	}else
	{
		HRPWM_setCounterCompareValue_Extend(Epwmbase,HRPWM_COUNTER_COMPARE_A1,(SetCMPA_A1<<8)|SetCMPHRA_A1);
		HRPWM_setCounterCompareValue_Extend(Epwmbase,HRPWM_COUNTER_COMPARE_B1,(SetCMPB_B1<<8)|SetCMPHRB_B1);
	}



}





