#ifndef _KERNEL_H
#define _KERNEL_H

#include "Knl_Config.h"
#include "Task.h"

//#ifndef DSPstatic
#define DSPstatic static
//#endif

//******************************************************************************
//*                 the constant definition
//******************************************************************************
#ifndef BIT
#define BIT(x)  (1L << (x))
#endif

#define ANYEVENT  (~0)
#define EVENT(id) BIT(id)
#define checkEventID(event, id) ((event) & EVENT(id))
#define checkEvent(event,eventMask) ((event) & (eventMask))
#define msToTicks(ms) ((uint32_t)(ms) * KNL_TICKS_PER_SEC / 1000)


#define KNL_TASK_LOWEST_PRIO (cPrioRsvd - 1) /* lowest priority, DO NOT CHANGE*/    
#define KNL_TASK_NUM  cPrioRsvd

//timer macro for task
//for all tasks, timer event is must be 0
#define KNL_EVENT_TIMER        0
//unit for period is ms
#define knlStartTimer(prio,period)    	{knlTCBTable[(prio)].targetTime = knlGetTargetTime(period);\
                                    	knlTCBTable[(prio)].timerPeriod = period;}
#define knlStopTimer(prio)            	{knlTCBTable[(prio)].timerPeriod = 0}

#define knlIsTimeOut(time) 				knlChkTimeOut(&time)
//******************************************************************************
//*                 the  global variable declarations
//******************************************************************************
extern knl_tcb_t knlTCBTable[KNL_TASK_NUM]; /* Table of TCB*/
extern knl_stack_t knlStackTable[KNL_TASK_NUM]; /* Table of Stack*/
//******************************************************************************
//*                 the function declarations
//******************************************************************************
extern void timerTickIsr(void);
extern void knlInitKernel(void);
extern void knlStartKernel(void);
extern void knlCreateTask(void(*task)(void), kernel_t stksize, kernel_t prio);
extern taskEvent_t knlWaitEvent(taskEvent_t eventWait);
extern taskEvent_t knlGetEvent(void);
extern void knlSendEventISR(kernel_t prio, kernel_t eventId);
extern void knlSendEvent(kernel_t prio, kernel_t eventId);
extern int32_t knlGetTargetTime(uint32_t msTime);
extern bool_t knlChkTimeOut(int32_t *targetTime);
extern void knlCtxSw(void);
extern void knlDelayTask(kernel_t prio,uint32_t time);
extern void knlExitInt(void);
extern void knlStartTask(void);
extern void knlIntCtxSw(void);
extern void knlTimerTick(void);
extern void Software_IRQHandler(void);
extern void  SysTickInitFreq (uint32_t  cpu_freq);
#endif
/*****************************end of the Kernel.h ****************************/
   





