#ifndef _KERNEL_H
#define _KERNEL_H

#include "OS_Config.h"
#include "Task.h"

//#ifndef DSPstatic
#define DSPstatic static
//#endif

//******************************************************************************
//*                 the constant definition
//******************************************************************************
#ifndef BIT
#define BIT(x)  (1L << (x))
#endif

#define ANYEVENT  (~0)
#define EVENT(id) BIT(id)
#define checkEventID(event, id) ((event) & EVENT(id))
#define checkEvent(event,eventMask) ((event) & (eventMask))
#define msToTicks(ms) ((uint32_t)(ms) * OS_TICKS_PER_SEC / 1000)


#define OS_TASK_LOWEST_PRIO (cPrioRsvd - 1) /* lowest priority, DO NOT CHANGE*/    
#define OS_TASK_NUM  cPrioRsvd

//timer macro for task
//for all tasks, timer event is must be 0
#define OS_EVENT_TIMER        0

//unit for period is ms
#define OSStartTimer(prio, cnt, period)    	do {																				\
												OSTCBTable[(prio)].targetTime = OSGetTargetTime(period) - cnt;		\
												OSTCBTable[(prio)].timerPeriod = period;								\
											}while(0);

#define OSStopTimer(prio)            		do {										\
												OSTCBTable[(prio)].timerPeriod = 0;		\
											} while(0);

#define OSIsTimeOut(time) 					OSChkTimeOut(&time)


#define		OSEventPend()				    OSMaskEventPend(~0)

//******************************************************************************
//*                 the  global variable declarations
//******************************************************************************
extern OS_tcb_t OSTCBTable[OS_TASK_NUM]; /* Table of TCB*/
extern OS_stack_t OSStackTable[OS_TASK_NUM]; /* Table of Stack*/
//******************************************************************************
//*                 the function declarations
//******************************************************************************

extern void OSInit(void);
extern void OSStart(void);
extern void OSTaskCreate(void(*task)(void), kernel_t stksize, kernel_t prio);
extern void OSEventSend(kernel_t prio, kernel_t eventId);
extern void OSISREventSend(kernel_t prio, kernel_t eventId);
extern void OSIntExit(void);
extern void OSTimerTick(void);
extern void OSSched(void);
extern void OSCtxSw(void);
extern void OSIntCtxSw(void);
extern taskEvent_t OSMaskEventPend(taskEvent_t eventWait);
extern taskEvent_t OSEventGet(void);

extern int32_t OSGetTargetTime(uint32_t msTime);
extern bool_t OSChkTimeOut(int32_t *targetTime);
extern void OSDelayTask(kernel_t prio,uint32_t time);
extern void OSStartTask(void);
extern void Software_IRQHandler(void);
extern void  SysTickInitFreq (uint32_t  cpu_freq);
#endif
/*****************************end of the Kernel.h ****************************/
   





