/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * @examplespi loopback bitfield
 * @brief  
 *   SPI Digital Loopback(using bitfield).
 *
 *   This routine uses bit fields to send and receive the data for the internal loopback test.
 * 
 *   Watch Variables:
 *                   - sdata - Data to send
 *                   - rdata - Received data
 *
 * @note:
 *   1.This test routine is designed to verify the basic SPI communication functionality.
 *
 */

/**
 * @examplespi loopback bitfield
 * @brief  
 *   SPI ڻ(ʹλ)
 * 
 *   ʹλڲزݵķա
 *
 *   :
 *           - sdata - ͵
 *           - rdata - յ
 *
 * @note:
 *   1.֤SPIͨŹ
 *
 */

#include "device.h"
#include "log.h"
#include "spi_loopback_bitfield.h"

int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    __disable_irq();
    /** @brief Initialize the SPI version 3.0 (Clock,Pinmux and Function). */
    spi_init();
    __enable_irq();

    spi_process();

    while (1) {

    }

    return 0;
}
