/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * @examplespi external loopback fifo interrupt
 * @brief  
 *   SPI Digital External Loopback(using FIFO interrupts).
 *
 *   In this routine, only one SPI is needed. Connect the MISO and MOSI of the SPI
 *   together. This is used for the external loopback test data transmission and
 *   reception (using FIFO interrupts) for one SPI. When TXFFST is less than the
 *   threshold (TXFFIL), a transmission interruption will be triggered. In the interruption,
 *   the data packet (sdata[8]) is sent. When RXFFST (data reception) is greater
 *   than or equal to the threshold (RXFFIL), a reception interruption will be triggered.
 *   At this time, data reception and verification are performed in the reception interruption.
 * 
 *   Watch Variables:
 *                   - sdata[8] - Data to send
 *                   - rdata[8] - Received data
 *
 * @note:
 *   1.This test routine is designed to verify the basic SPI communication functionality.
 *
 */

/**
 * @examplespi external loopback fifo interrupt
 * @brief  
 *   SPI ⻷(ʹFIFOж)
 * 
 *   ʱֻҪʹһSPISPIMISOMOSIж̽ӡһSPIⲿز
 *   ķգʹFIFOжϣTXFFSTСֵTXFFILʱᴥжϣж
 *   ݰsdata[8]RXFFSTݵĽգڵֵRXFFILᴥжϣ
 *   ʱڽжнݽպУ顣
 *
 *   :
 *           - sdata[8] - ͵
 *           - rdata[8] - յ
 *
 * @note:
 *   1.֤SPIͨŹ
 *
 */

#include "device.h"
#include "log.h"
#include "spi_external_loopback_fifo_interrupt.h"

int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    __disable_irq();
    /** @brief Initialize the SPI version 3.0 (Clock,Pinmux and Function). */
    spi_init();
    __enable_irq();

    spi_process();

    while (1) {

    }

    return 0;
}
