/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "software_simulation.h"
#include "device.h"


#define EEPROM_ADDRESS              0x50



int main(void)
{
	uint8_t data = 0;

	uint8_t txdata[4]={0x11,0x22,0x33,0x44};
	uint8_t rxdata[4]={0};

	i2c_init();

	i2c_write_one_byte(EEPROM_ADDRESS,0x10,0x28);

	DELAY_US(10000);

	i2c_read_one_byte(EEPROM_ADDRESS,0x10,&data);

	DELAY_US(10000);

	i2c_write_buffer(EEPROM_ADDRESS,0x00,txdata,sizeof(txdata));

	DELAY_US(50000);

	i2c_read_buffer(EEPROM_ADDRESS,0x00,rxdata,sizeof(rxdata));

	while(1);

    return 0;
}

