/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */



#include "device.h"
#include "i2c_state.h"

#define EEPROM_ADDRESS           0x50



int main(void)
{
	uint8_t tx_data[2] = {0x55,0x66};
	uint8_t rx_data[2] = {0};

	Device_init();

	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_I2C);

	SysCtl_resetI2c();

	i2c_init();

	i2c_write_data(EEPROM_ADDRESS,0X00,tx_data,2);

	/*
	 * Wait eeprom ready
	 */
	DELAY_US(5000);

	i2c_read_data(EEPROM_ADDRESS,0x00,rx_data,2);

	while(1);

    return 0;
}

