/*
 *   Copyright (c) GeJian Semiconductors 2025
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/**
  * @brief  main function.
  * @param  None
  * @return None
  */
int main(void)
{

    __disable_irq();
    Device_init();

    /**
     * @details  ʼϵSRAMԼУλbitΪֵ,ǰײʱѾSRAMʼSRAMʲΪʼϵʹУ
     * Ϊ֤,low_level_initѾ޸,ȡʼ
     *
     * ÿ鶼µһΣֵ֤
     * */

    /*
     * жΪ,У
     * */
    volatile uint32_t sum= 0 ;
    for (uint32_t addr = 0x10200000; addr<0x10200000 + 128*1024; addr += 4) {
          sum += HWREG(addr);
      }
    /*
     * ȡSRAM УʵʱϱFlag
     * */
    uint32_t sram0 = SysCtl_getSram0ParityErr();
    uint32_t sram1 = SysCtl_getSram1ParityErr();


    for(;;);

    return 0;
}

#ifdef __cplusplus
}
#endif
