// See LICENSE for license details.
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "log.h"

extern  void main_coremark(void);

/* Private functions ---------------------------------------------------------*/
/**
  * @brief
  * @param  None
  * @retval None
  */
int main(void)
{
	uint32_t oldTicks;

	__disable_irq();

	Device_init();

//	HWREG(SYSCTL_BASE + 0x670) = 7;

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_info("Hello DSP200 CoreMark!\r\n");
    log_info("Core running @ %d MHz\r\n", DEVICE_SYSCLK_FREQ/1000/1000);
    log_info("Code @ 0x%08X, Data @ 0x%08X\r\n", (uint32_t)main, (uint32_t)&oldTicks);

    main_coremark();

    for(;;);

    return 0;
}

