
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    clb_ex03_auxiliary_pwm.c
*   @brief
*   @details
*
//! This example configures a CLB tile as an auxiliary PWM generator. The
//! example uses combinatorial logic (LUTs), state machines (FSMs), counters,
//! and the high level controller (HLC) to demonstrate the PWM output generation
//! capabilities using CLB. and use aoc to generate an pwm pair
//!
//! See LICENSE for license details.
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#include "device.h"
#include "board.h"


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define EDA_CSIM                  0             //set to 1 when make target for simulation

#if EDA_CSIM != 0
#define LOG_LEVEL                 LOG_ERROR
void _putchar(char character)
{
    //do nothing
}
#else
#define LOG_LEVEL                 LOG_INFO
#endif

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

volatile uint16_t dutyValue=200;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */




void clb1ISR(void)
{
   //
    // Change duty cycle of PWM signal at the end of a period
    //
    if (dutyValue == 150)
    {
        dutyValue = 100U;
    }
    else
    {
        dutyValue = 150U;
    }

    //
    // Load new duty cycle value in HLC Registers
    //
    CLB_setHLCRegisters(CLB1_BASE, dutyValue, 0, 0, 0);

    CLB_clearInterruptTag(CLB1_BASE);
}

int main(void)
{
	 uint32_t oldTicks;

	__disable_irq();

	Device_init();
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_CLB);

   __enable_irq();

    CLB_init();
// OUTPUT TO IO
   	Interrupt_register(INT_CLB1, clb1ISR);
   	Interrupt_enable(INT_CLB1);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_OUT_MUX04_CLB1_OUT5 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX04);
    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_OUT_MUX00_CLB1_OUT1);
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_MUX00);

	CLB_setGPREG(CLB1_BASE, 1);

    while (1) {

//        }
    }

    return 0;
}

