/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
*   @file    clb_ex07_qepdiv.c
*   @brief
*   @details
*

 *! See LICENSE for license details.
 * See LICENSE for license details.  SET IN dap_master_template
 * This routine simulated the input of the QEP using PWM 1
 * and was set to a period of 100, pwmcmpa=50 and pwmcmpb=50.
 * QEPA-> CLBOUTPUTXBAR  0
 * QEPB-> CLBOUTPUTXBAR  1
 * QEPI-> OUTPUTXBAR     1
 */
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "board.h"
#include "pto_qepdiv.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define LED_STA_PIN		GPIO_PIN_LED2
#define myEPWM1base     EPWM1_BASE
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

uint16_t retval1;
uint16_t divVal = 4, divValnext = 4, indexWidth = 10;
uint16_t pwmperiod = 100;  //50000;
uint16_t pwmcmpa = 50;     //25000;
uint16_t pwmcmpb = 70;     //35000;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

//void eqep_test4_GPIO_Init();


int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;

    Device_init();

    __enable_irq();

    EALLOW;
// PWM1A--INPUTXBAR1--OUTPUTXBAR1
     XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT1,0);


//  clb Input configer
     Board_init();
//SET CLB0_OUTPUT4-CLB_XBAR
   XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX12_CLB2_OUT1);
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1, 12);
    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT2,XBAR_OUT_MUX14_CLB2_OUT3);
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2, 14);
 //
   XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_OUT_MUX11_CLB1_OUT6);
   XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT2, 11);
   XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT1, XBAR_OUT_MUX09_CLB1_OUT5);
   XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1, 9);

//
   pto_qepdiv_setupPeriph();
   //set all of GP register
   //
     // 2 => indicates the /4, change the number as needed -
     // should be 2^N Ex:/2, /4, /8, /16...
     // Frequency of the output QEPA or QEPB = Frequency of input QEPA or
     // QEPB / (2* divVal)
     // Index output comes when there is raising edge detected on Index input
     // Index output pulse width = indexWidth * (SYSCLK * 2) cycles
     //
     retval1 = pto_qepdiv_config(divVal, indexWidth);
   pto_qepdiv_startOperation(1);


while(1)
{

}


    return 0;
}
//void eqep_test4_GPIO_Init()
//{
//	//
//	// EPWM1 -> myEPWM1 Pinmux
//	//
//	GPIO_setPinConfig(GPIO_0_EPWM1_A);
//	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(0, GPIO_QUAL_SYNC);
//
//	GPIO_setPinConfig(GPIO_1_EPWM1_B);
//	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(1, GPIO_QUAL_SYNC);
//	GPIO_enableWritePin(1);
//
//    //
//	// EPWM2 -> myEPWM1 Pinmux
//	//
//	GPIO_setPinConfig(GPIO_2_EPWM2_A);
//	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
//
//	GPIO_setPinConfig(GPIO_3_EPWM2_B);
//	GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(3, GPIO_QUAL_SYNC);
//
//	GPIO_setPinConfig(GPIO_4_EPWM3_A);
//	GPIO_setPadConfig(4, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(4, GPIO_QUAL_SYNC);
//
//	GPIO_setPinConfig(GPIO_5_EPWM3_B);
//	GPIO_setPadConfig(5, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(5, GPIO_QUAL_SYNC);
//
//
//	//eqep1A
//	GPIO_setPinConfig(GPIO_6_EQEP1_A);
//	GPIO_setPadConfig(6, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(6, GPIO_QUAL_SYNC);
//    //eqep1B
//	GPIO_setPinConfig(GPIO_7_EQEP1_B);
//	GPIO_setPadConfig(7, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(7, GPIO_QUAL_SYNC);
//
//	//eqep1I
//	GPIO_setPinConfig(GPIO_9_EQEP1_INDEX);
//	GPIO_setPadConfig(9, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(9, GPIO_QUAL_SYNC);
//
//	//gpio30
//	GPIO_setPinConfig(GPIO_10_GPIO10);
//	GPIO_setPadConfig(10, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(10, GPIO_QUAL_SYNC);
//
//	GPIO_enableWritePin(10);
//
//
//}




