/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    CRC_ex01_basic_calc.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "float.h"
#include "stdio.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

uint8_t srcData8bit[8] = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88};
uint16_t srcData16bit[4] = {0x1122, 0x3344, 0x5566, 0x7788};
uint32_t srcData32bit[2] = {0x11223344, 0x55667788};
//input data = 0x11223344 0x55667788
//input data = 0x11223344 0x55667788

uint32_t CRC_result32[5];

uint32_t CRC_result16[8];

uint32_t CRC_result8[4];

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief
 * @param  None
 * @retval None
 */
//ROMFUNC_T
int main(void)
{
	uint32_t in_rev_cfg;
	uint32_t out_rev_cfg;
	uint32_t seed_value;
	uint32_t poly_size;
	uint32_t poly_value;
	uint32_t data_len;
	uint32_t rslt_xor_out;
	uint32_t i;
	uint32_t ts1=0;
	uint32_t ts2=0;
	Device_init();

	UartPrint_init(SCIA_BASE, 115200);

	//void CRC_setConfig(uint32_t base, CRC_POLYSIZE polySize, uint32_t polyValue,
	//		CRC_REVIN revInput, CRC_REVOUT revOutput, uint32_t seadValue)


	/***********************************************************************************
	 * Start of CRC32 examples
	 ***********************************************************************************/
	/*
	 					Expected Rslt	Poly		Init		RefIn	RefOut	XorOut
	CRC-32/AIXM 		0x59556055		0x814141AB	0x00000000	false	false	0x00000000
	CRC-32/AUTOSAR		0x22E62FB1		0xF4ACFB13	0xFFFFFFFF	true	true	0xFFFFFFFF
	CRC-32/BASE91-D		0xC98043E1		0xA833982B	0xFFFFFFFF	true	true	0xFFFFFFFF
	CRC-32/BZIP2		0x25404A32		0x04C11DB7	0xFFFFFFFF	false	false	0xFFFFFFFF
	CRC-32/CD-ROM-EDC	0x545844C0		0x8001801B	0x00000000	true	true	0x00000000
	*/
	poly_size = CRC_POLYSIZE_32BIT;
	poly_value = 0x814141AB;
	seed_value = 0x00000000;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData32bit)/4;
	rslt_xor_out = 0x00000000;
	CRC_result32[0] = CRC_calcResult32(CRC_BASE, srcData32bit, data_len)^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_32BIT;
	poly_value = 0xF4ACFB13;
	seed_value = 0xFFFFFFFF;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData32bit)/4;
	rslt_xor_out = 0xFFFFFFFF;
	CRC_result32[1] = CRC_calcResult32(CRC_BASE, srcData32bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_32BIT;
	poly_value = 0xA833982B;
	seed_value = 0xFFFFFFFF;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData32bit)/4;
	rslt_xor_out = 0xFFFFFFFF;
	CRC_result32[2] = CRC_calcResult32(CRC_BASE, srcData32bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_32BIT;
	poly_value = 0x04C11DB7;
	seed_value = 0xFFFFFFFF;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData32bit)/4;
	rslt_xor_out = 0xFFFFFFFF;
	CRC_result32[3] = CRC_calcResult32(CRC_BASE, srcData32bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_32BIT;
	poly_value = 0x8001801B;
	seed_value = 0x00000000;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData32bit)/4;
	rslt_xor_out = 0x00000000;
	CRC_result32[4] = CRC_calcResult32(CRC_BASE, srcData32bit, data_len) ^ rslt_xor_out;

	/***********************************************************************************
	 * end of CRC32 examples
	 ***********************************************************************************/


	/***********************************************************************************
	 * Start of CRC16 examples
	 ***********************************************************************************/
	/*
	CRC_Name		Expected Rslt	Poly	Init	RefIn	RefOut	XorOut
	CRC-16/ARC		0x4BE1			0x8005	0x0000	true	true	0x0000
	CRC-16/CDMA2000	0x09DC			0xC867	0xFFFF	false	false	0x0000
	CRC-16/CMS		0x1796			0x8005	0xFFFF	false	false	0x0000
	CRC-16/DDS-110	0x1BA6			0x8005	0x800D	false	false	0x0000
	CRC-16/DECT-X	0xD061			0x0589	0x0000	false	false	0x0000
	CRC-16/DNP		0xC8B0			0x3D65	0x0000	true	true	0xFFFF
	CRC-16/EN-13757	0xC88C			0x3D65	0x0000	false	false	0xFFFF
	*/
	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x8005;
	seed_value = 0x0000;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit)/2;
	rslt_xor_out = 0x0000;
	CRC_result16[0] = CRC_calcResult16(CRC_BASE, srcData16bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0xC867;
	seed_value = 0xFFFF;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit)/2;
	rslt_xor_out = 0x0000;
	CRC_result16[1] = CRC_calcResult16(CRC_BASE, srcData16bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x8005;
	seed_value = 0xFFFF;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit)/2;
	rslt_xor_out = 0x0000;
	CRC_result16[2] = CRC_calcResult16(CRC_BASE, srcData16bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x8005;
	seed_value = 0x800D;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit)/2;
	rslt_xor_out = 0x0000;
	CRC_result16[3] = CRC_calcResult16(CRC_BASE, srcData16bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x0589;
	seed_value = 0x0000;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit)/2;
	rslt_xor_out = 0x0000;
	CRC_result16[4] = CRC_calcResult16(CRC_BASE, srcData16bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x3D65;
	seed_value = 0x0000;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit)/2;
	rslt_xor_out = 0xFFFF;
	CRC_result16[5] = CRC_calcResult16(CRC_BASE, srcData16bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x3D65;
	seed_value = 0x0000;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit)/2;
	rslt_xor_out = 0xFFFF;
	CRC_result16[6] = CRC_calcResult16(CRC_BASE, srcData16bit, data_len) ^ rslt_xor_out;

	/***********************************************************************************
	 * end of CRC16 examples
	 ***********************************************************************************/


	/***********************************************************************************
	 * Start of CRC8 examples
	 ***********************************************************************************/
	/*
	CRC_Name		Expected Rslt	Poly	Init	RefIn	RefOut	XorOut
	CRC-8/AUTOSAR	0xE8			0x2F	0xFF	false	false	0xFF
	CRC-8/BLUETOOTH	0xE7			0xA7	0x00	true	true	0x00
	CRC-8/CDMA2000	0x2E			0x9B	0xFF	false	false	0x00
	CRC-8/DARC		0xB4			0x39	0x00	true	true	0x00
	*/
	poly_size = CRC_POLYSIZE_8BIT;
	poly_value = 0x2F;
	seed_value = 0xFF;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData8bit);
	rslt_xor_out = 0xFF;
	CRC_result8[0] = CRC_calcResult8(CRC_BASE, srcData8bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_8BIT;
	poly_value = 0xA7;
	seed_value = 0x00;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData8bit);
	rslt_xor_out = 0x00;
	CRC_result8[1] = CRC_calcResult8(CRC_BASE, srcData8bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_8BIT;
	poly_value = 0x9B;
	seed_value = 0xFF;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData8bit);
	rslt_xor_out = 0x00;
	CRC_result8[2] = CRC_calcResult8(CRC_BASE, srcData8bit, data_len) ^ rslt_xor_out;

	poly_size = CRC_POLYSIZE_8BIT;
	poly_value = 0x39;
	seed_value = 0x00;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData8bit);
	rslt_xor_out = 0x00;
	CRC_result8[3] = CRC_calcResult8(CRC_BASE, srcData8bit, data_len) ^ rslt_xor_out;

	for(;;);
	return 0;
}


#ifdef __cplusplus
}
#endif

