/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    xdma_dsp_ex03_epwm_duty_change.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <stdio.h>
#include "device.h"
#include "xdma_dsp_ex03_epwm_duty_change_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define TB_CLK    20000000U      
//#define PWM_CLK   500                      // We want to output at 5 kHz
//#define PRD_VAL   (TB_CLK / (PWM_CLK * 2))  // Calculate value period value
                                            // for up-down count mode
#define PRD_VAL        40000
#define PRD_VAL1   PRD_VAL/4  // Calculate value period value

#define EPWM_TIMER_TBPRD    40000
XDMA_ConfigParams dmaCfg;   //璁剧疆涓哄叏灞�鍙橀噺锛屽惁鍒欒缃负灞�閮ㄥ彉閲忓�间负闅忔満
typedef uint16_t uint16;

/* * 閫夋嫨PWM duty淇敼鏂瑰紡: 閫氳繃杞欢锛屾垨鑰呴�氳繃DMA * */
#define CHANGE_PWM_DUTY_BY_SW   0
#define CHANGE_PWM_DUTY_BY_DMA    1
#define TRIG_DMA_BY_TIMER       0
#define TRIG_DMA_BY_EPWMSOCA    1

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */


/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
volatile uint32_t done1, done2;
volatile uint32_t idx1, idx2;

/* 杩欐槸淇敼PWM duty鐨勬簮鏁版嵁锛屽?8缁勶紝姣忕粍16涓暟鎹? */
__attribute__((aligned(8))) uint16 pwm1_duty[16*8] = {
    1000, 2000,  3000,  4000,  5000,  6000,  7000,  8000,
    9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000,
    1000, 2000,  3000,  4000,  5000,  6000,  7000,  8000,
    9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000,
    1000, 2000,  3000,  4000,  5000,  6000,  7000,  8000,
    9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000,
    1000, 2000,  3000,  4000,  5000,  6000,  7000,  8000,
    9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000,
    1000, 2000,  3000,  4000,  5000,  6000,  7000,  8000,
    9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000,
    1000, 2000,  3000,  4000,  5000,  6000,  7000,  8000,
    9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000,
    1000, 2000,  3000,  4000,  5000,  6000,  7000,  8000,
    9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000,
    1000, 2000,  3000,  4000,  5000,  6000,  7000,  8000,
    9000, 10000, 11000, 12000, 13000, 14000, 15000, 16000,
};

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

void initEPWM(uint32_t base);
//void initEPWM(void);
//void EPWM1XINT_IRQHandler(void);


void Test_DmaInit(void);


/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/**
 * \brief   initEPWM - 鍒濆鍖朠WM杈撳?5KHz鏂规尝淇″彿锛屼笖閰嶇疆EPWM1SOCA淇″彿
 *
 * \param   none
 *
 * \retval  None
 */
void initEPWM(uint32_t base)
{
    EPWM_setEmulationMode(base, EPWM_EMULATION_STOP_AFTER_FULL_CYCLE);

    //
    // Set-up TBCLK
    //
    EPWM_setTimeBasePeriod(base, EPWM_TIMER_TBPRD);
    EPWM_setPhaseShift(base, 0U);
    EPWM_setTimeBaseCounter(base, 0U);

    //
    // Set Compare values
    //
    EPWM_setCounterCompareValue(base,
                                EPWM_COUNTER_COMPARE_A,
                                EPWM_TIMER_TBPRD/2);
    EPWM_setCounterCompareValue(base,
                                EPWM_COUNTER_COMPARE_B,
                                EPWM_TIMER_TBPRD/2);

    //
    // Set up counter mode
    //
    EPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP);
    EPWM_disablePhaseShiftLoad(base);
    EPWM_setClockPrescaler(base,
                           EPWM_CLOCK_DIVIDER_4,
						   EPWM_HSCLOCK_DIVIDER_10);

    //
    // Set up shadowing
    //
    EPWM_setCounterCompareShadowLoadMode(base,
                                         EPWM_COUNTER_COMPARE_A,
                                         EPWM_COMP_LOAD_ON_CNTR_ZERO);
    EPWM_setCounterCompareShadowLoadMode(base,
                                         EPWM_COUNTER_COMPARE_B,
                                         EPWM_COMP_LOAD_ON_CNTR_ZERO);

    //
    // Set actions
    //

    EPWM_setActionQualifierAction(base,
                                  EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);


    EPWM_setActionQualifierAction(base,
                                  EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

    EPWM_setActionQualifierAction(base,
                                  EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(base,
                                  EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);

    //
    // Interrupt where we will change the Compare Values
    // Select INT on Time base counter zero event,
    // Enable INT, generate INT on 1st event
    //
    EPWM_setInterruptSource(base, EPWM_INT_TBCTR_ZERO);
    EPWM_enableInterrupt(base);
    EPWM_setInterruptEventCount(base, 1U);

    EPWM_enableADCTrigger(base, EPWM_SOC_A);
    EPWM_setADCTriggerSource(base,
                             EPWM_SOC_A,
                             EPWM_SOC_TBCTR_ZERO);
    EPWM_setADCTriggerEventPrescale(base,
                                    EPWM_SOC_A,
                                       1);
    EPWM_clearADCTriggerFlag(base,
                             EPWM_SOC_A);
    EPWM_enableADCTrigger(base, EPWM_SOC_B);
    EPWM_setADCTriggerSource(base,
                             EPWM_SOC_B,
                             EPWM_SOC_TBCTR_ZERO);
    EPWM_setADCTriggerEventPrescale(base,
                                    EPWM_SOC_B,
                                       1);
    EPWM_clearADCTriggerFlag(base,
                             EPWM_SOC_B);
}


void DMA_CH1_IRQHandler()
{
    if (idx1 >= 40000 * 100)
    {
        done1 = 1;
        XDMA_stopChannel(DMA1_CH1_BASE);
    }
    idx1 ++;
    XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_BLOCK);
    __DSB();
}

void DMA_CH2_IRQHandler()
{
    if (idx2 >= 40000 * 100)
    {
        done2 = 1;
        XDMA_stopChannel(DMA1_CH2_BASE);
    }
    idx2 ++;
    XDMA_clearInterrupt(DMA1_CH2_BASE, XDMA_INT_BLOCK);
    __DSB();
}

void DSP_IRQ_Rigster(IRQn_Type idx, void* handler)
{
    CIDU_BroadcastExtInterrupt(IRQn_MAP_TO_EXT_ID(idx), CIDU_RECEIVE_INTERRUPT_EN(0));   //cpu1 only
    CIDU_ResetFirstClaimMode(IRQn_MAP_TO_EXT_ID(idx));
    ECLIC_Register_IRQ(idx, ECLIC_NON_VECTOR_INTERRUPT, ECLIC_LEVEL_TRIGGER, 1, 0, handler);
}


void Test_DmaInit(void){
    XDMA_initController(DMA1_BASE);

    XDMA_stopChannel(DMA1_CH1_BASE);
    XDMA_stopChannel(DMA1_CH2_BASE);
    dmaCfg.enableInterrupt = 1;
    dmaCfg.srcAddr = (uint32_t)(&pwm1_duty[0]);
    dmaCfg.destAddr = Test_EPWM + EPWM_O_CMPA + 2;
    dmaCfg.blockTS = 128;
    dmaCfg.ttfc    = XDMA_TT_FC_1_M2P_DMAC;//XDMA_TT_FC_1_M2P_DMAC;
    dmaCfg.srcBtl  = XDMA_BTL_1;
    dmaCfg.destBtl = XDMA_BTL_1;
    dmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
    dmaCfg.reloadSrc = XDMA_RELOAD;  //   寰幆鎼繍
    dmaCfg.reloadDst = XDMA_CONTIGOUS;


    dmaCfg.dmaDstReqId = DMAMUX_ReqId_PWMA;
    XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_BLOCK);
    XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_BLOCK);


    dmaCfg.destAddr = Test_EPWM + EPWM_O_CMPB + 2;
    dmaCfg.dmaDstReqId = DMAMUX_ReqId_PWMB;
    XDMA_configChannel(DMA1_CH2_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH2_BASE, XDMA_INT_BLOCK);
    XDMA_unMaskInterrupt(DMA1_CH2_BASE, XDMA_INT_BLOCK);
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
#if (GS32F3xx == 0x2000 || GS32F3xx == 0x0020)
#define DMA_INT_IRQn            (INT_DSP_DMA)
#else
#define DMA_INT_CH1_IRQn        (INT_DMA1_CH1)
#define DMA_INT_CH2_IRQn        (INT_DMA2_CH2)
#endif
 int main(void)
{
    int i,j, dir=0;    

    __disable_irq();

#if ((GS32F3xx & 0xFF00) || (GS32F00xx & 0xFF00))
    //
    // Initialize device clock and peripherals
    //
    Device_init();
#endif
    
#if ((GS32F3xx & 0xFF) || (GS32F00xx & 0xFF))
    //
    // config arm clock different from RISCV
    //
    HWREG(CRG_CFG_BASE + 0x008) = 1;        //Slow 2 normal
    HWREG(CRG_CFG_BASE + 0x010) = 0x0;      //arm clk div = 0
    HWREG(CRG_CFG_BASE + 0x01C) = 1;        //update
#endif

    idx1 = 0;
    idx2 = 0;
    done1 = 0;
    done2 = 0;
    UartPrint_init(LOG_SCI_BASE, 115200);

    // STOP_ON_RESET = 0 => start DSP core.
    //(*(uint32_t *)(0x40370048)) = 0x00;
    
    //
    // Disable pin locks and enable internal pullups.
    //
    //Device_initGPIO();
    Board_init();


    printf("NOTE::::: case go here\n");

#if ((GS32F3xx & 0xFF) || (GS32F00xx & 0xFF))
    //
    // config for pwm output
    //
    //HWREG(0x4003F000 + 0x120) = 0x10000;
    HWREG(0x4003F000 + 0x44) = 0x40000;
    HWREG(0x40008000 + 0x31C) = 0x3;
#endif

    //
    // Enable specific PIE & CPU interrupts:
    // DMA interrupt - Group 7, interrupt 1
    //
    DSP_IRQ_Rigster(DMA_INT_CH1_IRQn, DMA_CH1_IRQHandler);
    DSP_IRQ_Rigster(DMA_INT_CH2_IRQn, DMA_CH2_IRQHandler);
    //
    // Setup ePWM1 to generate a 5 kHz signal to be an input to the eQEP
    //
    initEPWM(Test_EPWM);
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    __enable_irq();
    
    //CpuTimer_Init(CPUTIMER0_BASE, 2000000);        //100ms @ 20MHz

    //
    // Loop indefinitely
    //
#if CHANGE_PWM_DUTY_BY_SW
    while(1)
    {
        i = EPWM_getCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A);
        if(dir == 0){
            i -= 10;
        } else {
            i += 10;
        }
        if(i >= PRD_VAL){
            dir = 0;
        }
        if(i <= 0) {
            dir = 1;
        }
        EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, i);
        for(j=1000; j>0; j--);
    }
#elif CHANGE_PWM_DUTY_BY_DMA
    
    Test_DmaInit();

    XDMA_startChannel(DMA1_CH1_BASE);
    XDMA_startChannel(DMA1_CH2_BASE);

    while(done1 == 0 || done2 == 0);
    
#endif
        
    while(1) {}
}



#ifdef __cplusplus
}
#endif
/*****END OF FILE****/

