/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex11_sci_autoback_with_timeout_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "xdma_dsp_ex11_uart_board.h"
#include "printf.h"
#include "board_cfg.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
char UART_TXBUF[32];
char UART_RXBUF[32]={0};
uint64_t ctrl = 0,config = 0;
char tmpstr[32] = {0};

#if (defined(LOAD_MONITOR) && LOAD_MONITOR)
__IO DLOAD_STRUCT    dload;
#endif


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void uart_init(void)
{
    //gpio设置
	GPIO_setPadConfig(28, GPIO_PIN_TYPE_PULLUP);
    GPIO_setPadConfig(29, GPIO_PIN_TYPE_PULLUP);
	GPIO_setPinConfig(SCIA_TX_PIN);
    GPIO_setPinConfig(SCIA_RX_PIN);

	SCI_setBaud(SCIA_BASE,DEVICE_APBCLK_FREQ,115200);

	SCI_setInitConfig(SCIA_BASE, SCI_CONFIG_PAR_NONE, SCI_STOP_1BIT, SCI_CHAR_8BITS);

    SCI_enableFIFO(SCIA_BASE);
    SCI_setFIFOInterruptLevel(SCIA_BASE, SCI_FIFO_TX0, SCI_FIFO_RX4);



}


void dma_uart_tx()
{
	XDMA_ConfigParams dmaCfg1 = {0};
	for(int i=0;i<32;i++)
	{
		UART_TXBUF[i]='A';
	}
	UART_TXBUF[30] = '\r';
	UART_TXBUF[31] = '\n';
	printf("buf ready\r\n");

	XDMA_stopChannel(DMA1_CH1_BASE);
	dmaCfg1.enableInterrupt = 1;
	dmaCfg1.srcAddr = (uint32_t)(&UART_TXBUF[0]);
	dmaCfg1.destAddr = (SCIA_BASE + SCI_O_RBR_THR_DLL);
	dmaCfg1.blockTS = 32;
	dmaCfg1.ttfc = XDMA_TT_FC_1_M2P_DMAC;
	dmaCfg1.srcBtl  = XDMA_BTL_1;
	dmaCfg1.destBtl = XDMA_BTL_1;
	dmaCfg1.srcAddrDirect = XDMA_ADDR_INCRE;
	dmaCfg1.destAddrDirect = XDMA_ADDR_NO_CHANGE;
	dmaCfg1.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	dmaCfg1.destTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	dmaCfg1.dmaDstReqId = DMAMUX_ReqId_scia_tx;
	XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg1);
	XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);
	XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);

}


void dma_uart_rx()
{
	int i = 0;

	XDMA_ConfigParams dmaCfg2 = {0};

	XDMA_stopChannel(DMA1_CH2_BASE);
	dmaCfg2.enableInterrupt = 1;
	dmaCfg2.srcAddr = (SCIA_BASE + SCI_O_RBR_THR_DLL);
	dmaCfg2.destAddr = (uint32_t)(&UART_RXBUF[0]);
	dmaCfg2.blockTS = 32;
	dmaCfg2.ttfc = XDMA_TT_FC_2_P2M_DMAC;
	dmaCfg2.srcBtl  = XDMA_BTL_4;
	dmaCfg2.destBtl = XDMA_BTL_4;
	dmaCfg2.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
	dmaCfg2.destAddrDirect = XDMA_ADDR_INCRE;
	dmaCfg2.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	dmaCfg2.destTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_scia_rx;


    XDMA_configChannel(DMA1_CH2_BASE, &dmaCfg2);
	XDMA_clearInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);
	XDMA_unMaskInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);

}





void dma_uart(void)
{
	uart_init();
	volatile uint8_t ret;
	volatile uint32_t res;
	XDMA_initController(DMA1_BASE);

	dma_uart_tx();
	dma_uart_rx();


	XDMA_startChannel(DMA1_CH1_BASE);
	XDMA_startChannel(DMA1_CH2_BASE);
	res=XDMA_isFifoEmpty(DMA1_CH2_BASE);

	while((XDMA_getInterruptStatus(DMA1_CH1_BASE) & XDMA_INT_TFR) == 0);
	printf("DMA controlled UART Tx test done.\r\n");



	printf("please input 8 chars\r\n");



	while(!(ret&XDMA_INT_TFR))
	{
		ret=XDMA_getInterruptStatus(DMA1_CH2_BASE);
	}

	printf("UART_RXBUF:");
	for(int i=0;i<8;i++)
	{
		printf("%c",UART_RXBUF[i]);
	}
	printf("\r\nDMA controlled UART Rx test done.\r\n");





}




#ifdef __cplusplus
}
#endif

