/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "epwm_board.h"
#include "cpu.h"
#include "epwm.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

float32_t pwm_duty = 0.5;
float32_t duty_array[5] = {0.6,0.4,0.1,0.7,0.8};

volatile uint32_t pwm_base[6] =
    {EPWM1_BASE, EPWM2_BASE, EPWM3_BASE, EPWM4_BASE, EPWM5_BASE, EPWM6_BASE};

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */



//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;
	PinMux_init();
	//10ms
	InitTimerModule(DEVICE_SYSCLK_FREQ/100);
	for(int i  = 0;i < 6;i++)
	{
		InitEPWMModule(pwm_base[i],PWM_PRD);
	}
}

/*
 *ʼ
 */
void PinMux_init()
{ 
	//
	// EPWM1 -> EPWM1 Pinmux
	//
	GPIO_setPinConfig(EPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM2 -> EPWM2 Pinmux
	//
	GPIO_setPinConfig(EPWM2_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(EPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM2_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM3 -> EPWM3 Pinmux
	//
	GPIO_setPinConfig(EPWM3_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM3_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM4 -> EPWM4 Pinmux
	//
	GPIO_setPinConfig(EPWM4_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM4_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM4_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM4_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM4_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM4_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM5
	//
	GPIO_setPinConfig(EPWM5_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM5_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM5_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM5_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM5_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM5_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM6 -> EPWM6 Pinmux
	//
	GPIO_setPinConfig(EPWM6_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM6_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM6_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM6_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM6_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM6_EPWMB_GPIO, GPIO_QUAL_SYNC);

}

/*ʼEPWM
 * baseEPWMַ
 * periodֵ
 */
void InitEPWMModule(uint32_t base, uint32_t period)
{
#if (UPDOWM == 0)
	EPWM_setClockPrescaler(base, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(base, period);
	EPWM_setTimeBaseCounter(base, 0);
	EPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP);
	EPWM_disablePhaseShiftLoad(base);
	EPWM_setPhaseShift(base, 0);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 0);
	EPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, 0);
	EPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, 0);
	EPWM_setCounterCompareShadowLoadMode_Extend(base, EPWM_COUNTER_COMPARE_B1, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_enableCounterCompare_Extend(base);

	EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB1);
#else
	EPWM_setClockPrescaler(base, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(base, period);
	EPWM_setTimeBaseCounter(base, 0);
	EPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP_DOWN);
	EPWM_disablePhaseShiftLoad(base);
	EPWM_setPhaseShift(base, 0);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 0);
	EPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, 0);
	EPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, 0);
	EPWM_setCounterCompareShadowLoadMode_Extend(base, EPWM_COUNTER_COMPARE_B1, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_A1, 0);
	EPWM_setCounterCompareShadowLoadMode_Extend(base, EPWM_COUNTER_COMPARE_A1, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_enableCounterCompare_Extend(base);

	EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
	EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
	EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);
#endif

}



/* TIMER1ʼ
 * period
 */
void InitTimerModule(uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, period);
	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);
	Interrupt_SetPriority( INT_TIMER1,  1,  0);
}



/* TIMER1ж
 * ڴжиEPWM duty
 */
void TIMER1_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	CPUTimer_ClearInterruptStatus(CPUTIMER1_BASE);


	for(uint16_t i = 0;i < 6;i++)
	{
#if (UPDOWM == 0)
		EPWM_MinDB_updateDutyUp(pwm_base[i],pwm_duty,PWM_PRD+1);
#else
		EPWM_MinDB_updateDutyUpDown(pwm_base[i],pwm_duty,PWM_PRD);
#endif
	}
}


/*ϼģʽEPWMռձ
 * baseEPWMַ
 * duty. ռձ
 * periodֵ
 */
void EPWM_MinDB_updateDutyUp(uint32_t base,float32_t duty,uint32_t period)
{

	// ʱ+Сռձ < AQռձ  ʱ+Сռձ < -AQռձ
	if(DB_delay+Min_duty <= duty && (1-duty) >= Min_duty+DB_delay)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, DB_delay*period);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, duty*period);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, (duty+DB_delay)*period);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB1);
	}
	// ʱ+Сռձ > AQռձ > Сռձ
	else if(Min_duty+DB_delay > duty && duty > Min_duty)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, DB_delay*period);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, (DB_delay+Min_duty)*period);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, (Min_duty+2*DB_delay)*period);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB1);
	}
	// AQռձ < Сռձ
	else if(duty <= Min_duty)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 0);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, 0);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, (duty+DB_delay)*period);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB1);
	}
	// ʱ+Сռձ > 1 - AQռձ > Сռձ
	else if((1-duty) > Min_duty && (1-duty) < Min_duty + DB_delay)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, DB_delay*period);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, (1-DB_delay-Min_duty)*period);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, (1-Min_duty)*period);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB1);
	}
	// 1 - AQռձ < Сռձ
	else if((1-duty) <= Min_duty)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, DB_delay*period);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, duty*period);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, 0);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB1);
	}
}




/*¼ģʽEPWMռձ
 * baseEPWMַ
 * duty. ռձ
 * periodֵ
 */
void EPWM_MinDB_updateDutyUpDown(uint32_t base,float32_t duty,uint32_t period)
{
	volatile uint32_t c_temp = (1- duty) *period;
	volatile uint32_t db_temp = DB_delay *period;
	volatile uint32_t min_temp = Min_duty *period;

	// ʱ+Сռձ < AQռձ  ʱ+Сռձ < -AQռձ
	if(DB_delay+Min_duty <= duty && (1-duty) >= Min_duty+DB_delay)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, c_temp+2*db_temp);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, c_temp);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_A1, c_temp);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, c_temp - 2*db_temp);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);
	}
	// ʱ+Сռձ > AQռձ > Сռձ
	else if(Min_duty+DB_delay > duty && duty > Min_duty)
	{
		if(c_temp + 2*db_temp > period){
			EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 2*period - c_temp - 2*db_temp);
			EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
			EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		}
		else{
			EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, c_temp + 2*db_temp);
			EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
			EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		}

		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, 2*period - c_temp - 2*db_temp - 2*min_temp);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, 2*period - c_temp - 4*db_temp - 2*min_temp);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_A1, c_temp);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);
	}
	// AQռձ < Сռձ
	else if(duty <= Min_duty)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, 0);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, 0);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_A1, c_temp);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, c_temp-2*db_temp);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);
	}
	// ʱ+Сռձ > 1 - AQռձ > Сռձ
	else if((1-duty) > Min_duty && (1-duty) < Min_duty + DB_delay)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, c_temp + 2*db_temp);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, 2*min_temp+2*db_temp-c_temp);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_A1, c_temp);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, 2*min_temp-c_temp);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);
	}
	// 1 - AQռձ < Сռձ
	else if((1-duty) <= Min_duty)
	{
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, c_temp+2*db_temp);
		EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, c_temp);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_A1, 0);
		EPWM_setCounterCompareValue_Extend(base, EPWM_COUNTER_COMPARE_B1, 0);

		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA1);
		EPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB1);
	}
}






#ifdef __cplusplus

#endif

