/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    sram.c
*   @brief
*
*/

#include "fsmc.h"
#include "sram.h"


void FSMC_Config()
{
    FSMC_NORSRAMInitTypeDef  FSMC_NORSRAMInitStructure;
    FSMC_NORSRAMTimingInitTypeDef  readWriteTiming;
    FSMC_NORSRAMTimingInitTypeDef  writeTiming;

    //this is the recommended settings, pin mapping as follwoing:
#if 0
    //FSMC_A0/A1/A2/A3... = EMIF_BA0/BA1/A0/A1...;
    SysCtl_setFsmcCfg(0x00);
#else
    //FSMC_A0/A1/A2/A3... = EMIF_A0/A1...;
    SysCtl_setFsmcCfg(0x04);
#endif

    readWriteTiming.FSMC_AddressSetupTime = 0x06;
    readWriteTiming.FSMC_AddressHoldTime = 0x06;
    readWriteTiming.FSMC_DataSetupTime = 0x0C;
    readWriteTiming.FSMC_BusTurnAroundDuration = 0x0F;
    readWriteTiming.FSMC_CLKDivision = 0x0F;
    readWriteTiming.FSMC_DataLatency = 0x0F;
    readWriteTiming.FSMC_AccessMode = FSMC_AccessMode_A;


    writeTiming.FSMC_AddressSetupTime = 0x06;
    writeTiming.FSMC_AddressHoldTime = 0x06;
    writeTiming.FSMC_DataSetupTime = 0x0C;
    writeTiming.FSMC_BusTurnAroundDuration = 0x0F;
    writeTiming.FSMC_CLKDivision = 0x0F;
    writeTiming.FSMC_DataLatency = 0x0F;
    writeTiming.FSMC_AccessMode = FSMC_AccessMode_A;

    //useful settings for SRAM
    FSMC_NORSRAMInitStructure.FSMC_Bank = FSMC_Bank1_NORSRAM1;
    FSMC_NORSRAMInitStructure.FSMC_ExtendedMode = FSMC_ExtendedMode_Enable;
    FSMC_NORSRAMInitStructure.FSMC_MemoryDataWidth = FSMC_MemoryDataWidth_16b;
    FSMC_NORSRAMInitStructure.FSMC_MemoryType =FSMC_MemoryType_SRAM;
    FSMC_NORSRAMInitStructure.FSMC_WriteOperation = FSMC_WriteOperation_Enable;
    
    //not used for SRAMs
    FSMC_NORSRAMInitStructure.FSMC_BurstAccessMode =FSMC_BurstAccessMode_Disable;
    FSMC_NORSRAMInitStructure.FSMC_AsynchronousWait=FSMC_AsynchronousWait_Disable;
    FSMC_NORSRAMInitStructure.FSMC_DataAddressMux = FSMC_DataAddressMux_Disable;
    FSMC_NORSRAMInitStructure.FSMC_WaitSignal = FSMC_WaitSignal_Disable;
    FSMC_NORSRAMInitStructure.FSMC_WaitSignalActive = FSMC_WaitSignalActive_BeforeWaitState;
    FSMC_NORSRAMInitStructure.FSMC_WaitSignalPolarity = FSMC_WaitSignalPolarity_Low;
    FSMC_NORSRAMInitStructure.FSMC_WrapMode = FSMC_WrapMode_Disable;
    FSMC_NORSRAMInitStructure.FSMC_WriteBurst = FSMC_WriteBurst_Disable;
    
    FSMC_NORSRAMInitStructure.FSMC_ReadWriteTimingStruct = &readWriteTiming;
    FSMC_NORSRAMInitStructure.FSMC_WriteTimingStruct = &writeTiming;

    //it's allowed to change specific timing settings for each bank
    //Configure FSMC Bank0(EMIF Bank1), 0x70000000
    FSMC_NORSRAMInitStructure.FSMC_Bank = FSMC_Bank1_NORSRAM1;
    FSMC_NORSRAMInit(&FSMC_NORSRAMInitStructure);
    FSMC_NORSRAMCmd(FSMC_Bank1_NORSRAM1, FSMC_ENABLE);

    //Configure FSMC Bank2(EMIF Bank2), 0x74000000
    FSMC_NORSRAMInitStructure.FSMC_Bank = FSMC_Bank1_NORSRAM2;
    FSMC_NORSRAMInit(&FSMC_NORSRAMInitStructure);
    FSMC_NORSRAMCmd(FSMC_Bank1_NORSRAM2, FSMC_ENABLE);

    //Configure FSMC Bank3(EMIF Bank3), 0x78000000
    FSMC_NORSRAMInitStructure.FSMC_Bank = FSMC_Bank1_NORSRAM3;
    FSMC_NORSRAMInit(&FSMC_NORSRAMInitStructure);
    FSMC_NORSRAMCmd(FSMC_Bank1_NORSRAM3, FSMC_ENABLE);

    //Configure FSMC Bank4(EMIF Bank4), 0x7C000000
    FSMC_NORSRAMInitStructure.FSMC_Bank = FSMC_Bank1_NORSRAM2;
    FSMC_NORSRAMInit(&FSMC_NORSRAMInitStructure);
    FSMC_NORSRAMCmd(FSMC_Bank1_NORSRAM2, FSMC_ENABLE);
}


void SRAM_GPIO_Config()
{
    //control
    GPIO_setAnalogMode(13, GPIO_ANALOG_DISABLED);

    GPIO_setPinConfig(FSMC_WE_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_WE_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_OE_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_OE_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_CS1_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_CS1_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_CS2_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_CS2_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_CS3_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_CS3_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_UDQM_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_UDQM_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_LDQM_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_LDQM_GPIO_PIN, GPIO_QUAL_ASYNC);

    //address bus
    GPIO_setAnalogMode(20, GPIO_ANALOG_DISABLED);
    GPIO_setAnalogMode(21, GPIO_ANALOG_DISABLED);

    GPIO_setPinConfig(FSMC_A0_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A0_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A1_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A1_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A2_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A2_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A3_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A3_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A4_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A4_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A5_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A5_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A6_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A6_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A7_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A7_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A8_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A8_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A9_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A9_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A10_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A10_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A11_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A11_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A12_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A12_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A13_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A13_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_A14_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_A14_GPIO_PIN, GPIO_QUAL_ASYNC);


    //16bits DATA bus
    GPIO_setPinConfig(FSMC_D0_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D0_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D1_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D1_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D2_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D2_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D3_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D3_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D4_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D4_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D5_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D5_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D6_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D6_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D7_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D7_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D8_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D8_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D9_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D9_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D10_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D10_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D11_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D11_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D12_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D12_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D13_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D13_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D14_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D14_GPIO_PIN, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(FSMC_D15_GPIO_PIN_CFG);
    GPIO_setQualificationMode(FSMC_D15_GPIO_PIN, GPIO_QUAL_ASYNC);
}

void SRAM_Init(void)
{
#if (GS32F3xx != 0x0021)
    SRAM_GPIO_Config();
#endif
    FSMC_Config();
}
