/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "48PWM_board.h"
#include "device.h"
#include "SFO_v2.h"
#include "clb_config.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
//s->dcdc.Duty
s_point s_tmp;
s_point* s = &s_tmp;
//Ĭʱ10%duty
volatile uint16_t DB_delay = 1000;
//APWMⲨǰıȽֵ
volatile uint16_t APWM_CMP[4] = {0};
//APWMⲨ־
volatile uint8_t  APWM_TZFlag[4] = {0};
//Ⲩ
volatile uint8_t tz_test = 0;

//ʱ1ļ
uint32_t timer_cnt = 0;

//18EPWMĻַ
volatile uint32_t pwm_base[] =
{EPWM1_BASE, EPWM2_BASE, EPWM3_BASE, EPWM4_BASE, EPWM5_BASE, EPWM6_BASE, EPWM7_BASE, EPWM8_BASE,\
EPWM9_BASE, EPWM10_BASE, EPWM11_BASE, EPWM12_BASE, EPWM13_BASE, EPWM14_BASE, EPWM15_BASE, EPWM16_BASE,\
EPWM17_BASE, EPWM18_BASE};

//HRPWM SFOУ׼
SFO_Params_t SFO_ParamsStruct;
uint16_t status;

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */



//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;
	//EPWM duty
	s->dcdc.Duty = 0.5;

	PinMux_init();

	for(uint16_t i = 0;i < 18;i++)
	{
		if(i < 6){
		InitHRPWM_CLBModule(pwm_base[i],PWM_PRD);}
		else{
		InitHRPWMModule(pwm_base[i],PWM_PRD);}
	}
	initEPWMTZ(EPWM16_BASE);
	initEPWMINT();
	InitCLBModule();
	//APWM
	InitECAPModule();
	InitXBARModule();
	//10msһ
	InitTimerModule(DEVICE_APBCLK_FREQ/100);

	EDIS;
}

/*
 *ʼ
 */
void PinMux_init()
{ 
	//
	// EPWM1 -> EPWM1 Pinmux
	//
	GPIO_setPinConfig(EPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM2 -> EPWM2 Pinmux
	//
	GPIO_setPinConfig(EPWM2_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(EPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM2_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM3 -> EPWM3 Pinmux
	//
	GPIO_setPinConfig(EPWM3_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM3_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM4 -> EPWM4 Pinmux
	//
	GPIO_setPinConfig(EPWM4_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM4_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM4_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM4_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM4_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM4_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM5
	//
	GPIO_setPinConfig(EPWM5_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM5_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM5_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM5_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM5_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM5_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM6 -> EPWM6 Pinmux
	//
	GPIO_setPinConfig(EPWM6_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM6_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM6_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM6_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM6_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM6_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
    // EPWM7
	//
    GPIO_setPinConfig(EPWM7_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM7_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM7_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM7_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM7_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM7_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM8
    //
	GPIO_setPinConfig(EPWM8_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(EPWM8_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM8_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM8_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM8_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM8_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM9
	//
	GPIO_setPinConfig(EPWM9_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM9_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM9_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM9_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM9_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM9_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM10
	//
	GPIO_setPinConfig(EPWM10_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM10_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM10_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM10_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM10_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM10_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM11
	//
	GPIO_setPinConfig(EPWM11_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM11_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM11_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM11_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM11_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM11_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM12
	//
	GPIO_setPinConfig(EPWM12_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM12_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM12_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM12_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM12_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM12_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM13
	//
	GPIO_setPinConfig(EPWM13_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM13_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM13_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM13_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM13_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM13_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM14
	//
	GPIO_setPinConfig(EPWM14_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM14_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM14_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM14_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM14_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM14_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM15
	//
	GPIO_setPinConfig(EPWM15_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM15_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM15_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM15_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM15_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM15_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM16
	//
	GPIO_setPinConfig(EPWM16_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM16_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM16_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM16_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM16_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM16_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM17
	//
	GPIO_setPinConfig(EPWM17_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM17_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM17_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM17_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM17_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM17_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM18
	//
	GPIO_setPinConfig(EPWM18_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(EPWM18_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM18_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(EPWM18_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(EPWM18_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(EPWM18_EPWMB_GPIO, GPIO_QUAL_SYNC);


	//CLB EPWM1~4A B8·
	GPIO_setPinConfig(GPIO_32_CLB_OUTPUTXBAR1);
	GPIO_setPadConfig(32, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(32, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_33_CLB_OUTPUTXBAR2);
	GPIO_setPadConfig(33, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(33, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_34_CLB_OUTPUTXBAR3);
	GPIO_setPinConfig(GPIO_35_CLB_OUTPUTXBAR4);
	GPIO_setPinConfig(GPIO_46_CLB_OUTPUTXBAR9);
	GPIO_setPinConfig(GPIO_47_CLB_OUTPUTXBAR10);
	GPIO_setPinConfig(GPIO_48_CLB_OUTPUTXBAR11);
	GPIO_setPinConfig(GPIO_49_CLB_OUTPUTXBAR12);

	//OUTXBAR APWM:ECAP2~5
	GPIO_setPinConfig(GPIO_58_OUTPUTXBAR1);
	GPIO_setPadConfig(58, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(58, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_59_OUTPUTXBAR2);
	GPIO_setPadConfig(59, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(59, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_60_OUTPUTXBAR3);
	GPIO_setPadConfig(60, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(60, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_61_OUTPUTXBAR4);
	GPIO_setPadConfig(61, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(61, GPIO_QUAL_SYNC);

	//CLBⲨԴ͵ƽⲨʹLoopback,ֶ1411/0CLBⲨ
	GPIO_setPinConfig(GPIO_141_GPIO141);
	GPIO_setPadConfig(141, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(141, GPIO_DIR_MODE_OUT);
	GPIO_setQualificationMode(141, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(141,1);
	GPIO_writePin(141, 1);
}

/*ʼEPWM7~18PWMEPWM
 * baseEPWMַ
 * periodֵ
 */
void InitEPWMModule(uint32_t base, uint32_t period)
{
	HRPWM_setClockPrescaler(base, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(base, period);
	HRPWM_setTimeBaseCounter(base, 0);
	HRPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP);
	EPWM_disablePhaseShiftLoad(base);
	EPWM_setPhaseShift(base, 0);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, PWMA_CMP);
	HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, PWMB_CMP);
	HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);

	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);

	//DB
	EPWM_setRisingEdgeDeadBandDelayInput(base,EPWM_DB_INPUT_EPWMA);
	EPWM_setFallingEdgeDeadBandDelayInput(base,EPWM_DB_INPUT_EPWMB);
	EPWM_setRisingEdgeDelayCount(base,DB_delay);
	EPWM_setFallingEdgeDelayCount(base,DB_delay);
	EPWM_setDeadBandDelayMode(base,EPWM_DB_RED,TRUE);
	EPWM_setDeadBandDelayMode(base,EPWM_DB_FED,TRUE);

	EPWM_setDeadBandDelayPolarity(base,EPWM_DB_FED,EPWM_DB_POLARITY_ACTIVE_LOW);
}

void InitHRPWMModule(uint32_t base,uint32_t period)
{

	InitEPWMModule(base, period);
	//Զ
#if(HRPWM_AUTO_ENABLE)
		HRPWM_enableAutoConversion(base);
#else
		HRPWM_disableAutoConversion(base);
#endif

	HRPWM_setMEPEdgeSelect(base, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_FALLING_EDGE);
	HRPWM_setMEPControlMode(base, HRPWM_CHANNEL_A, HRPWM_MEP_DUTY_PERIOD_CTRL);
	HRPWM_setCounterCompareShadowLoadEvent(base, HRPWM_CHANNEL_A,HRPWM_LOAD_ON_CNTR_PERIOD);
	/*--SFO ṹ0--*/
	SFO_Struct_deinit(&SFO_ParamsStruct);
	/*--SFO ṹ帳ֵloop_cntƼ4~5--*/
	SFO_Struct_init(&SFO_ParamsStruct,5);
}

/*ʼEPWM1~6PWMEPWM
 * baseEPWMַ
 * periodֵ
 */
void InitHRPWM_CLBModule(uint32_t base,uint32_t period)
{
	HRPWM_setClockPrescaler(base, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	EPWM_setTimeBasePeriod(base, period);
	HRPWM_setTimeBaseCounter(base, 0);
	HRPWM_setTimeBaseCounterMode(base, EPWM_COUNTER_MODE_UP);
	EPWM_disablePhaseShiftLoad(base);
	EPWM_setPhaseShift(base, 0);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_A, PWMA_CMP);
	HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
	EPWM_setCounterCompareValue(base, EPWM_COUNTER_COMPARE_B, PWMB_CMP);
	HRPWM_setCounterCompareShadowLoadMode(base, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);

	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	HRPWM_setActionQualifierAction(base, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);

	//Զ
#if(HRPWM_AUTO_ENABLE)
		HRPWM_enableAutoConversion(base);
#else
		HRPWM_disableAutoConversion(base);

#endif

	HRPWM_setMEPEdgeSelect(base, HRPWM_CHANNEL_A, HRPWM_MEP_CTRL_FALLING_EDGE);
	HRPWM_setMEPControlMode(base, HRPWM_CHANNEL_A, HRPWM_MEP_DUTY_PERIOD_CTRL);
	HRPWM_setCounterCompareShadowLoadEvent(base, HRPWM_CHANNEL_A,HRPWM_LOAD_ON_CNTR_PERIOD);

	//DB
	EPWM_setRisingEdgeDeadBandDelayInput(base,EPWM_DB_INPUT_EPWMA);
	EPWM_setFallingEdgeDeadBandDelayInput(base,EPWM_DB_INPUT_EPWMB);

	if(base == EPWM5_BASE || base == EPWM6_BASE)
	{
		EPWM_setRisingEdgeDelayCount(base,DB_delay);
		EPWM_setFallingEdgeDelayCount(base,DB_delay);
		EPWM_enableSyncOutPulseSource(base,EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);
	}
	else
	{	//ԭdelay CLBCLBеĹdelay
		EPWM_setRisingEdgeDelayCount(base,DB_delay + CLB_delay);
		EPWM_setFallingEdgeDelayCount(base,DB_delay + CLB_delay);
	}
	EPWM_setDeadBandDelayMode(base,EPWM_DB_RED,TRUE);
	EPWM_setDeadBandDelayMode(base,EPWM_DB_FED,TRUE);

	EPWM_setDeadBandDelayPolarity(base,EPWM_DB_FED,EPWM_DB_POLARITY_ACTIVE_LOW);


}


/*ʼEPWMTZAⲨ
 * baseַ
 */
void initEPWMTZ(uint32_t base)
{
	EPWM_setTripZoneAction(base, EPWM_TZ_ACTION_EVENT_TZA, EPWM_TZ_ACTION_LOW);
}

/*ʼEPWM1cnt=0 ж
 * dutyڴжִ
 */
void initEPWMINT(void)
{
	EPWM_enableInterrupt(EPWM1_BASE);
	EPWM_setInterruptSource(EPWM1_BASE,EPWM_INT_TBCTR_ZERO);
	EPWM_setInterruptEventCount(EPWM1_BASE,1);
	Interrupt_register(INT_EPWM1, EPWM1_IRQHandler);
	Interrupt_enable(INT_EPWM1);
	Interrupt_SetPriority( INT_EPWM1,  1,  0);
}

/*CLB1ʼ
 *
 */
void CLB_TILE1_init(){

	//pmw1a
	CLB_configGlobalInputMux(TILE1_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_EPWM1A_AQ);
	CLB_configGPInputMux(TILE1_BASE, CLB_IN0,  CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(TILE1_BASE, CLB_IN0,DB_delay,1);

	//pmw1b
	CLB_configGlobalInputMux(TILE1_BASE, CLB_IN1, CLB_GLOBAL_IN_MUX_EPWM1B_AQ);
	CLB_configGPInputMux(TILE1_BASE, CLB_IN1, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(TILE1_BASE, CLB_IN1,1,DB_delay);

	//pmw2a
	CLB_configGlobalInputMux(TILE1_BASE, CLB_IN2, CLB_GLOBAL_IN_MUX_EPWM2A_AQ);
	CLB_configGPInputMux(TILE1_BASE, CLB_IN2, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(TILE1_BASE, CLB_IN2,DB_delay,1);

	//pmw2b
	CLB_configGlobalInputMux(TILE1_BASE, CLB_IN3, CLB_GLOBAL_IN_MUX_EPWM2B_AQ);
	CLB_configGPInputMux(TILE1_BASE, CLB_IN3,  CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(TILE1_BASE, CLB_IN3,1,DB_delay);

	//pmw3a
	CLB_configGlobalInputMux(TILE1_BASE, CLB_IN4, CLB_GLOBAL_IN_MUX_EPWM3A_AQ);
	CLB_configGPInputMux(TILE1_BASE, CLB_IN4, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(TILE1_BASE, CLB_IN4,DB_delay,1);

	//pmw3b
	CLB_configGlobalInputMux(TILE1_BASE, CLB_IN5, CLB_GLOBAL_IN_MUX_EPWM3B_AQ);
	CLB_configGPInputMux(TILE1_BASE, CLB_IN5, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(TILE1_BASE, CLB_IN5,1,DB_delay);

	// INPUT tz from GPIO
	CLB_configGlobalInputMux(TILE1_BASE, CLB_IN6, CLB_GLOBAL_IN_MUX_XBAE_CLB_INPUT_SEL1_OUT);
	CLB_configGPInputMux(TILE1_BASE, CLB_IN6, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputFilter(TILE1_BASE, CLB_IN6, CLB_FILTER_NONE);

	CLB_configGlobalInputMux(TILE1_BASE, CLB_IN7, CLB_GLOBAL_IN_MUX_EPWM1_XSYNCI);
	CLB_configGPInputMux(TILE1_BASE, CLB_IN7, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputFilter(TILE1_BASE, CLB_IN7, CLB_FILTER_NONE);

	CLB_setGPREG(TILE1_BASE,0);
}

/*CLB2ʼ
 *
 */
void CLB_TILE2_init()
{
	//pmw4a
	CLB_configGlobalInputMux(TILE2_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_EPWM4A_AQ);
	CLB_configGPInputMux(TILE2_BASE, CLB_IN0,  CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(TILE2_BASE, CLB_IN0,DB_delay,1);

	//pmw4b
	CLB_configGlobalInputMux(TILE2_BASE, CLB_IN1, CLB_GLOBAL_IN_MUX_EPWM4B_AQ);
	CLB_configGPInputMux(TILE2_BASE, CLB_IN1, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(TILE2_BASE, CLB_IN1,1,DB_delay);

	// INPUT tz from GPIO
	CLB_configGlobalInputMux(TILE2_BASE, CLB_IN6, CLB_GLOBAL_IN_MUX_XBAE_CLB_INPUT_SEL1_OUT);
	CLB_configGPInputMux(TILE2_BASE, CLB_IN6, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputFilter(TILE2_BASE, CLB_IN6, CLB_FILTER_NONE);

	CLB_configGlobalInputMux(TILE2_BASE, CLB_IN7, CLB_GLOBAL_IN_MUX_EPWM1_XSYNCI);
	CLB_configGPInputMux(TILE2_BASE, CLB_IN7, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputFilter(TILE2_BASE, CLB_IN7, CLB_FILTER_NONE);

	CLB_setGPREG(TILE2_BASE,0);
}






/*ECAP2-5ʼ
 *ECAPʼãperiod  ͬһEPWMȣcmpareֵҪΪEPWM cmpare+DB_delay
 */
void InitECAPModule(){
    // Stops Time stamp counter.

	ECAP_stopCounter(ECAP2_BASE);
	ECAP_stopCounter(ECAP3_BASE);
	ECAP_stopCounter(ECAP4_BASE);
	ECAP_stopCounter(ECAP5_BASE);

	// Sets eCAP in APWM mode.

	ECAP_enableAPWMMode(ECAP2_BASE);
	ECAP_enableAPWMMode(ECAP3_BASE);
	ECAP_enableAPWMMode(ECAP4_BASE);
	ECAP_enableAPWMMode(ECAP5_BASE);

	// Set eCAP APWM period.

	ECAP_setAPWMPeriod(ECAP2_BASE,ECAP2_PRD);
	ECAP_setAPWMPeriod(ECAP3_BASE,ECAP3_PRD);
	ECAP_setAPWMPeriod(ECAP4_BASE,ECAP4_PRD);
	ECAP_setAPWMPeriod(ECAP5_BASE,ECAP5_PRD);

	// Set eCAP APWM on or off time count.

	ECAP_setAPWMCompare(ECAP2_BASE,ECAP2_CMP);
	ECAP_setAPWMCompare(ECAP3_BASE,ECAP3_CMP);
	ECAP_setAPWMCompare(ECAP4_BASE,ECAP4_CMP);
	ECAP_setAPWMCompare(ECAP5_BASE,ECAP5_CMP);

	// Set eCAP APWM polarity.
	ECAP_setAPWMPolarity(ECAP2_BASE,ECAP_APWM_ACTIVE_LOW);
	ECAP_setAPWMPolarity(ECAP3_BASE,ECAP_APWM_ACTIVE_LOW);
	ECAP_setAPWMPolarity(ECAP4_BASE,ECAP_APWM_ACTIVE_LOW);
	ECAP_setAPWMPolarity(ECAP5_BASE,ECAP_APWM_ACTIVE_LOW);

	// Sets a phase shift value count.

	ECAP_setPhaseShiftCount(ECAP2_BASE,0U);
	ECAP_setPhaseShiftCount(ECAP3_BASE,0U);
	ECAP_setPhaseShiftCount(ECAP4_BASE,0U);
	ECAP_setPhaseShiftCount(ECAP5_BASE,0U);

	// Disable counter loading with phase shift value.

	ECAP_enableLoadCounter(ECAP2_BASE);
	ECAP_enableLoadCounter(ECAP3_BASE);
	ECAP_enableLoadCounter(ECAP4_BASE);
	ECAP_enableLoadCounter(ECAP5_BASE);

	// Configures Sync out signal mode.

	ECAP_setSyncOutMode(ECAP2_BASE,ECAP_SYNC_OUT_SYNCI);
	ECAP_setSyncOutMode(ECAP3_BASE,ECAP_SYNC_OUT_SYNCI);
	ECAP_setSyncOutMode(ECAP4_BASE,ECAP_SYNC_OUT_SYNCI);
	ECAP_setSyncOutMode(ECAP5_BASE,ECAP_SYNC_OUT_SYNCI);

	// Configures emulation mode.

	ECAP_setEmulationMode(ECAP2_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(ECAP3_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(ECAP4_BASE,ECAP_EMULATION_STOP);
	ECAP_setEmulationMode(ECAP5_BASE,ECAP_EMULATION_STOP);

	// Set up the source for sync-in pulse..

	ECAP_setSyncInPulseSource(ECAP2_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM5);
	ECAP_setSyncInPulseSource(ECAP3_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM5);
	ECAP_setSyncInPulseSource(ECAP4_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM6);
	ECAP_setSyncInPulseSource(ECAP5_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM6);

	// Starts Time stamp counter for ECAP0.

	ECAP_startCounter(ECAP2_BASE);
	ECAP_startCounter(ECAP3_BASE);
	ECAP_startCounter(ECAP4_BASE);
	ECAP_startCounter(ECAP5_BASE);

}

//CLB ķⲨźѡ,͵ƽⲨʹCLBź͡
void InitCLB_INPUTXBAR()
{
	XBAR_setInputPin(CLBINPUTXBAR_BASE, XBAR_INPUT1, CLBINPUT_TZ);
	XBAR_setCLBMuxConfig(XBAR_AUXSIG0,XBAR_CLB_MUX08_ECAP5_CLB);
	XBAR_enableClbMux(XBAR_AUXSIG0, XBAR_MUX08);
}

/* XBARʼ
 * CLB  ECAPͨѡ
 */
void InitOUTPUTXBAR(){
	//CLB OUT
    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT1, XBAR_OUT_MUX00_CLB1_OUT1 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX00);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT2,XBAR_OUT_MUX01_CLB1_OUT2 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_MUX01);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT3,XBAR_OUT_MUX02_CLB1_OUT3 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT3,XBAR_MUX02);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT4, XBAR_OUT_MUX03_CLB1_OUT4 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT4,XBAR_MUX03);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR2_BASE, XBAR_OUTPUT9,XBAR_OUT_MUX04_CLB1_OUT5 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR2_BASE,XBAR_OUTPUT9,XBAR_MUX04);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR2_BASE, XBAR_OUTPUT10,XBAR_OUT_MUX05_CLB1_OUT6 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR2_BASE,XBAR_OUTPUT10,XBAR_MUX05);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR2_BASE, XBAR_OUTPUT11,XBAR_OUT_MUX12_CLB2_OUT1 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR2_BASE,XBAR_OUTPUT11,XBAR_MUX12);

    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR2_BASE, XBAR_OUTPUT12,XBAR_OUT_MUX13_CLB2_OUT2 );
    XBAR_enableOutputMux(CLBOUTPUTXBAR2_BASE,XBAR_OUTPUT12,XBAR_MUX13);

    //ECAP OUT
    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX02_ECAP2_OUT );
    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX02);

    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT2,XBAR_OUT_MUX04_ECAP3_OUT );
    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_MUX04);

    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT3,XBAR_OUT_MUX06_ECAP4_OUT );
    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT3,XBAR_MUX06);

    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT4,XBAR_OUT_MUX08_ECAP5_OUT );
    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT4,XBAR_MUX08);

}

/* TIMER1ʼ
 * period
 */
void InitTimerModule(uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER1_BASE, period);
	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);
	Interrupt_SetPriority( INT_TIMER1,  1,  0);
}

/* CLBʼ
 *
 */
void InitCLBModule()
{
	CLB_TILE1_init();
	CLB_TILE2_init();
	initTILE0(TILE1_BASE);
	initTILE1(TILE2_BASE);
    // clb enable  start operate
    CLB_enableCLB(TILE1_BASE);
    CLB_enableCLB(TILE2_BASE);
}

/* XBARʼ
 *
 */
void InitXBARModule(void)
{
	InitCLB_INPUTXBAR();
	InitOUTPUTXBAR();
}


/* ĳCLBͨıʱ
 * globalMuxCfgCLBEPWMź
 * delay_cntʱcnt
 * delay_type0 falling delay. 1 rising delay
 * EPWM1Aһ globalMuxCfg = CLB_GLOBAL_IN_MUX_EPWM1A_AQ
 * 					delay_cnt = EPWM1ADB_delay cnt
 * 					delay_type = 0½ʱ
 */
void Set_CLB_DBdelay( CLB_GlobalInputMux globalMuxCfg,uint32_t delay_cnt,uint8_t delay_type)
{
	switch (globalMuxCfg) {
		case CLB_GLOBAL_IN_MUX_EPWM1A_AQ:
			if(delay_type)
				CLB_selectInputDelay(TILE1_BASE, CLB_IN0,1,delay_cnt);
			else
				CLB_selectInputDelay(TILE1_BASE, CLB_IN0,delay_cnt,1);
			break;
		case CLB_GLOBAL_IN_MUX_EPWM1B_AQ:
			if(delay_type)
				CLB_selectInputDelay(TILE1_BASE, CLB_IN1,1,delay_cnt);
			else
				CLB_selectInputDelay(TILE1_BASE, CLB_IN1,delay_cnt,1);
			break;

		case CLB_GLOBAL_IN_MUX_EPWM2A_AQ:
			if(delay_type)
				CLB_selectInputDelay(TILE1_BASE, CLB_IN2,1,delay_cnt);
			else
				CLB_selectInputDelay(TILE1_BASE, CLB_IN2,delay_cnt,1);
			break;

		case CLB_GLOBAL_IN_MUX_EPWM2B_AQ:
			if(delay_type)
				CLB_selectInputDelay(TILE1_BASE, CLB_IN3,1,delay_cnt);
			else
				CLB_selectInputDelay(TILE1_BASE, CLB_IN3,delay_cnt,1);
			break;

		case CLB_GLOBAL_IN_MUX_EPWM3A_AQ:
			if(delay_type)
				CLB_selectInputDelay(TILE1_BASE, CLB_IN4,1,delay_cnt);
			else
				CLB_selectInputDelay(TILE1_BASE, CLB_IN4,delay_cnt,1);
			break;

		case CLB_GLOBAL_IN_MUX_EPWM3B_AQ:
			if(delay_type)
				CLB_selectInputDelay(TILE1_BASE, CLB_IN5,1,delay_cnt);
			else
				CLB_selectInputDelay(TILE1_BASE, CLB_IN5,delay_cnt,1);
			break;

		case CLB_GLOBAL_IN_MUX_EPWM4A_AQ:
			if(delay_type)
				CLB_selectInputDelay(TILE2_BASE, CLB_IN0,1,delay_cnt);
			else
				CLB_selectInputDelay(TILE2_BASE, CLB_IN0,delay_cnt,1);
			break;

		case CLB_GLOBAL_IN_MUX_EPWM4B_AQ:
			if(delay_type)
				CLB_selectInputDelay(TILE2_BASE, CLB_IN1,1,delay_cnt);
			else
				CLB_selectInputDelay(TILE2_BASE, CLB_IN1,delay_cnt,1);
			break;

		default:
			break;
	}
}


/* ֶCMPֵȥʵ䶯cmp_cntΪCMPϣDBdelay
 * ҲAPWMռձȡ
 * base:ECAPĻַ
 * cmp_cnt:ECAPCMPֵ
 * 磺ͬһPWMͨ duty = 50%,prd = 1000DBʱ100cnt˴APWMcmp_cnt = 0.5*1000+100 = 700
 * ECAPCMPΪߣ˴cmp_cnt õԽ为ҲԽ*/
void Set_APWM_DBdelay(uint32_t base,uint16_t cmp_cnt)
{
	uint16_t i = 0;
	i = (base-ECAP2_BASE)/0x200U;
	if(APWM_TZFlag[i] != 0){
		return ;
	}
	ECAP_setAPWMCompare(base,cmp_cnt);
}


/* base,ΪECAPĻַ
 * APWMķⲨⲨǰıȽֵźű
 */
void APWM_TZ_Trigger(uint32_t base)
{

	uint16_t i = 0;
	i = (base-ECAP2_BASE)/0x200U;
	if(APWM_TZFlag[i] != 0)
	{
		return;
	}
	APWM_CMP[i] = HWREG(base + ECAP_O_CAP2);
	ECAP_setAPWMPolarity(base,ECAP_APWM_ACTIVE_HIGH);
	ECAP_setAPWMCompare(base,0);
	//APWMⲨ־1
	APWM_TZFlag[i] = 1;
}


/* base,ΪECAPĻַ
 * ⲨǰıȽֵ¸ֵʹ
 */
void APWM_TZ_Clear(uint32_t base)
{
	uint16_t i = 0;
	i = (base-ECAP2_BASE)/0x200U;
	if(APWM_CMP[i] == 0 || APWM_TZFlag[i] != 1)
	{
		return;
	}

	ECAP_setAPWMCompare(base,APWM_CMP[i]);
	ECAP_setAPWMPolarity(base,ECAP_APWM_ACTIVE_LOW);
	//APWMⲨ־0
	APWM_TZFlag[i] = 0;
}

/* APWMķⲨ־
 * base,ΪECAPĻַ
 * ֻAPWMķⲨ־ֵⲨǰıȽֵ
 */
void APWM_TZ_ClearFlag(uint32_t base)
{
	uint16_t i = 0;
	i = (base-ECAP2_BASE)/0x200U;
	//APWMⲨ־0
	APWM_TZFlag[i] = 0;
}

/* disable ĳCLBͨķⲨʹTZźź
 * base,ΪCLBĻַ
 * outputΪCLBoutͨ
 */
void Disable_CLB_TZ(uint32_t base, CLB_Outputs output)
{
	uint16_t phash=output%2;
	if(phash==0)
	{
		CLB_configAOC(base, output, ClbAoc_Rever_TZ_Aphase);
	}
	else{
		CLB_configAOC(base, output, ClbAoc_TZ_Bphase);
	}
}

/* enable ĳCLBͨķⲨʹTZźź
 * base,ΪCLBĻַ
 * outputΪCLBoutͨ
 */
void Enable_CLB_TZ(uint32_t base, CLB_Outputs output)
{
	uint16_t phash=output%2;
	if(phash==0)
	{
		CLB_configAOC(base, output, ClbTZ_enableA);
	}
	else{
		CLB_configAOC(base, output, ClbTZ_enableB);
	}
}



/* TIMER1ж
 * ڴжнHRPWMУ׼
 */
void TIMER1_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER1_BASE);
	CPUTimer_ClearInterruptStatus(CPUTIMER1_BASE);
	//2s ˢһ
	if(timer_cnt++ == 200)
	{
		status = SFO(&SFO_ParamsStruct);
		//һУ׼
	    if (status !=0)
	    {
//	    	error();
	    }


		//ԣⲨECAPⲨEPWMⲨ
		if(tz_test){
			APWM_TZ_Trigger(ECAP2_BASE);
			APWM_TZ_Trigger(ECAP3_BASE);
			APWM_TZ_Trigger(ECAP4_BASE);
			APWM_TZ_Trigger(ECAP5_BASE);
			EPWM_forceTripZoneEvent(EPWM16_BASE,EPWM_TZ_FORCE_EVENT_OST);
		}
		else{
			APWM_TZ_Clear(ECAP2_BASE);
			APWM_TZ_Clear(ECAP3_BASE);
			APWM_TZ_Clear(ECAP4_BASE);
			APWM_TZ_Clear(ECAP5_BASE);
			EPWM_clearTripZoneFlag(EPWM16_BASE, EPWM_TZ_FLAG_OST);
		}
		timer_cnt = 0;
	}
}

/* EPWM1ж
 * ڴжиEPWMԼECAPduty
 */
void EPWM1_IRQHandler(void)
{

	for(uint16_t i = 0;i < 18;i++)
	{
#if(HRPWM_AUTO_ENABLE)
			Update_HrDuty_Auto(pwm_base[i],(EPWM_getTimeBasePeriod(pwm_base[i])+1),HRPWM_COUNTER_COMPARE_A);
#else
			Update_HrDuty_Manual(pwm_base[i],(EPWM_getTimeBasePeriod(pwm_base[i])+1),HRPWM_COUNTER_COMPARE_A);
#endif
			Update_duty(pwm_base[i],HRPWM_COUNTER_COMPARE_B);
	}
	/*
	 * PWMduty֮ͬAPWMduty
	 * CLB£PWMıCLBҲԼͬ仯
	 */
	Set_APWM_DBdelay(ECAP2_BASE,ECAP2_CMP);
	Set_APWM_DBdelay(ECAP3_BASE,ECAP3_CMP);
	Set_APWM_DBdelay(ECAP4_BASE,ECAP4_CMP);
	Set_APWM_DBdelay(ECAP5_BASE,ECAP5_CMP);

	Set_CLB_DBdelay(CLB_GLOBAL_IN_MUX_EPWM1A_AQ, DB_delay, 0);
	EPWM_clearEventTriggerInterruptFlag(EPWM1_BASE);
}

/*HRPWMautoconvʹô˺ȥCMPֺС
 * base:EPWMַ
 * period:EPWMֵ
 * cmpareҪõCMPHR,HRPWM_COUNTER_COMPARE_A / HRPWM_COUNTER_COMPARE_B
 */
void Update_HrDuty_Auto(uint32_t base,uint32_t period,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;
	//CMPHR = frac(duty*period) * 256 +0.5 СֵļԼֵ
	cmp_set =( (s ->dcdc.Duty*period- (uint32_t)(s->dcdc.Duty*period)) *256) + 0.5;

	//ֵļԼֵ

	if(cmpare){
		cmp_set += (uint32_t)(PWMB_CMP)<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		cmp_set += (uint32_t)(PWMA_CMP)<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}



/*δHRPWMautoconvʹô˺ȥCMPֺС
 * base:EPWMַ
 * period:EPWMֵ
 * cmpareҪõCMPHR,HRPWM_COUNTER_COMPARE_A / HRPWM_COUNTER_COMPARE_B
 */
void Update_HrDuty_Manual(uint32_t base,uint32_t period,HRPWM_CounterCompareModule cmpare)
{
	uint16_t hr_step;
	uint32_t cmp_set = 0;
	hr_step = HRPWM_getCalibratedHRmstep();
	//CMPHR = frac(duty*period) * hrstep +0.5
	cmp_set =  (s->dcdc.Duty*period - (uint32_t)(s->dcdc.Duty*period)) * hr_step+0.5;
	if(cmpare){
		HRPWM_setCmpHRINT(base,cmp_set,hr_step,HRPWM_COUNTER_COMPARE_B);
		cmp_set += (uint32_t)(PWMB_CMP)<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		HRPWM_setCmpHRINT(base,cmp_set,hr_step,HRPWM_CHANNEL_A);
		cmp_set += (uint32_t)(PWMA_CMP)<<8;
		HRPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}

/*
 * ֻͨCMP
 */
void Update_duty(uint32_t base,HRPWM_CounterCompareModule cmpare)
{
	uint32_t cmp_set = 0;
	if(cmpare){
		cmp_set = (uint32_t)(PWMB_CMP);
		EPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_B,cmp_set);
	}
	else{
		cmp_set = (uint32_t)(PWMA_CMP);
		EPWM_setCounterCompareValue(base,HRPWM_COUNTER_COMPARE_A,cmp_set);
	}
}


#ifdef __cplusplus

#endif

