/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    i2c_ex08_slave.c
*   @brief
*   @details
*
*  This program is used for the GS32 to act as a slave device to conduct I2C
*  communication with the master device.
*  The master and the slave send 0-15 to each other through I2C
*  communication. Users can compare slave_rxdata[] to check the running results.Also
*  you can check the message from printf function in Serial port assistant
*
*          Master                   Slave(GS32)
*         I2CA_SDA --------------- I2CA_SDA(IO0)
*         I2CA_SCL --------------- I2CA_SCL(IO1)
*            GND   ---------------   GND
*/

#ifdef __cplusplus
extern "C"{
#endif


#include "slave.h"
#include "device.h"



 int main(void)
 {
     Device_init();

     SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_I2C);

     SysCtl_resetI2c();

     UartPrint_init(SCIA_BASE, 115200);
     i2c_test03_master_slave();

     /* We should never get here as control is now taken by the scheduler */
     for(;;);
 }


#ifdef __cplusplus
}
#endif

