/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"
#include "xbar_test.h"

int main(void)
{
	// 初始?
    Device_init();
    UartPrint_init(LOG_SCI_BASE, 115200);


//    GPIO_setLoopBack(28,true);
//    GPIO_setAnalogMode(20,GPIO_ANALOG_DISABLED);
//    GPIO_enableWritePin(29);
//    GPIO_setLoopBack(29,true);
//    //配置GPIO20的MUX复用为OUTPUTXBAR9
//    GPIO_setPinConfig(GPIO_29_OUTPUTXBAR6);

	//配置GPIO0为输出模?
	GPIO_setDirectionMode(0,GPIO_DIR_MODE_OUT);

	//配置GPIO1为正常GPIO
	GPIO_setPinConfig(GPIO_1_GPIO1);

    GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);     //gpio
    GPIO_setPinConfig(GPIO_25_OUTPUTXBAR2);
    GPIO_setPinConfig(GPIO_26_OUTPUTXBAR3);     //gpio
    GPIO_setPinConfig(GPIO_27_OUTPUTXBAR4);
    GPIO_setPinConfig(GPIO_7_OUTPUTXBAR5);     //gpio
    GPIO_setPinConfig(GPIO_9_OUTPUTXBAR6);
    GPIO_setPinConfig(GPIO_30_OUTPUTXBAR7);     //gpio
    GPIO_setPinConfig(GPIO_31_OUTPUTXBAR8);
    GPIO_setPinConfig(GPIO_46_OUTPUTXBAR9);     //gpio
    GPIO_setPinConfig(GPIO_47_OUTPUTXBAR10);
    GPIO_setPinConfig(GPIO_66_OUTPUTXBAR11);     //gpio
    GPIO_setPinConfig(GPIO_67_OUTPUTXBAR12);
    GPIO_setPinConfig(GPIO_50_OUTPUTXBAR13);     //gpio
    GPIO_setPinConfig(GPIO_51_OUTPUTXBAR14);
    GPIO_setPinConfig(GPIO_52_OUTPUTXBAR15);     //gpio
    GPIO_setPinConfig(GPIO_53_OUTPUTXBAR16);

	for(uint32_t i=0;i <= XBAR_OUTPUT8; i++ )
	{

		XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT1,1);
		XBAR_enableOutputMux(OUTPUTXBAR_BASE,i,XBAR_MUX01);
		XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,i,XBAR_OUT_MUX01_INPUTXBAR1);

		//设置OUTPUTXBAR锁存功能
		XBAR_setOutputLatchMode(OUTPUTXBAR_BASE,i,1);

		GPIO_writePin(0,1);
		log_info("OUTPUTXBAR%d  Latch%d\r\n",i+1,XBAR_getOutputLatchStatus(OUTPUTXBAR_BASE, i));
	}


	log_info("xxxxxx\r\n");


	for(uint32_t n=8 ;n <= XBAR_OUTPUT16; n++)
	{

		XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT1,1);
		XBAR_enableOutputMux(OUTPUTXBAR_BASE,n,XBAR_MUX01);
		XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE + 0x100,n,XBAR_OUT_MUX01_INPUTXBAR1);

		//设置OUTPUTXBAR锁存功能
		XBAR_setOutputLatchMode(OUTPUTXBAR_BASE + 0x100,n,1);

		GPIO_writePin(0,1);
		log_info("OUTPUTXBAR%d  Latch%d\r\n",n+1,XBAR_getOutputLatchStatus(OUTPUTXBAR_BASE + 0x100, n));
	}




    return 0;
}

