/*
 * 07_i2c_state.c
 *
 *  Created on: 2025 Mar 27
 *      Author: hpec
 */

#include <06_i2c_state.h>

void i2c_init()
{
	GPIO_setPinConfig(I2CA_SDA_PINMUX);
    GPIO_setPadConfig(I2CA_SDA_PIN, GPIO_PIN_TYPE_PULLUP);
    GPIO_setQualificationMode(I2CA_SDA_PIN, GPIO_QUAL_ASYNC);

	GPIO_setPinConfig(I2CA_SCL_PINMUX);
    GPIO_setPadConfig(I2CA_SCL_PIN, GPIO_PIN_TYPE_PULLUP);
    GPIO_setQualificationMode(I2CA_SCL_PIN, GPIO_QUAL_ASYNC);

	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_I2C);

	SysCtl_resetI2c();

//    I2C_disableModule(I2C_BASE);
	I2C_REGS.I2CMDR.bit.IRS = 0;


//    I2C_initController(I2C_BASE, DEVICE_APBCLK_FREQ, 400000, I2C_DUTYCYCLE_50);
	I2C_REGS.I2CPSC = 5;
	I2C_REGS.I2CCLKH = 7;
	I2C_REGS.I2CCLKL = 8;


//    I2C_setAddressMode(I2C_BASE, I2C_ADDR_MODE_7BITS);
	I2C_REGS.I2CMDR.bit.XA = 0;

//    I2C_setBitCount(I2C_BASE, I2C_BITCOUNT_8);
	I2C_REGS.I2CMDR.bit.BC = 0;

//    I2C_setEmulationMode(I2C_BASE, I2C_EMULATION_FREE_RUN);
	I2C_REGS.I2CMDR.bit.FREE = 1;

//    I2C_enableModule(I2C_BASE);
	I2C_REGS.I2CMDR.bit.IRS = 1;
}

uint8_t i2c_read_data(uint8_t dev_addr,uint16_t reg_addr,uint8_t *pdata,uint16_t datalen)
{
	I2C_Stage state = I2C_READY;
	uint16_t directionFlag = 0;
	uint16_t status = 0;
	uint16_t stopFlag = 0;
	uint16_t cnt = 0;

	while(!(stopFlag)){
		switch(state){
			case I2C_READY:

				if(directionFlag == 0){
//					if(I2C_isBusBusy(I2C_BASE))
					if(I2C_REGS.I2CSTR.bit.BB != 0)
						return 1;
//					I2C_setConfig(I2C_BASE, I2C_CONTROLLER_SEND_MODE);
					I2C_REGS.I2CMDR.bit.MST = 1;
					I2C_REGS.I2CMDR.bit.TRX = 1;

//					I2C_setDataCount(I2C_BASE, 1);
					I2C_REGS.I2CCNT.all = 1;

				}else if(directionFlag == 1){
//					I2C_setConfig(I2C_BASE, I2C_CONTROLLER_RECEIVE_MODE);
					I2C_REGS.I2CMDR.bit.MST = 1;
					I2C_REGS.I2CMDR.bit.TRX = 0;

//					I2C_setDataCount(I2C_BASE, datalen);
					I2C_REGS.I2CCNT.all = datalen;

				}
//				I2C_setTargetAddress(I2C_BASE, dev_addr);
				I2C_REGS.I2CSAR.all = dev_addr;


				state = I2C_START;
				break;

			case I2C_START:

//				I2C_sendStartCondition(I2C_BASE);
				I2C_REGS.I2CMDR.bit.STT = 1;

				if(directionFlag == 0){
//					I2C_putData(I2C_BASE,reg_addr);
					I2C_REGS.I2CDXR = reg_addr;

					directionFlag = 1;
					state = I2C_READY;
					do{
//						status = I2C_getStatus(I2C_BASE);
						status = I2C_REGS.I2CSTR.all;

					}while(!(status & I2C_STS_TX_DATA_RDY));

				}else if(directionFlag == 1){

					state = I2C_TRANSFER;

				}

				break;

			case I2C_TRANSFER:

				for(cnt = 0;cnt<datalen;cnt++){
					do{
//						status = I2C_getStatus(I2C_BASE);
						status = I2C_REGS.I2CSTR.all;

					}while(!(status & I2C_STS_RX_DATA_RDY));

//					pdata[cnt] = I2C_getData(I2C_BASE);
					pdata[cnt] = I2C_REGS.I2CDRR;

				}

				state = I2C_STOP;

				break;

			case I2C_STOP:

//				I2C_sendStopCondition(I2C_BASE);
				I2C_REGS.I2CMDR.bit.STP = 1;

				stopFlag = 1;

				break;
		}
	}

	return 0;
}

uint8_t i2c_write_data(uint8_t dev_addr,uint16_t reg_addr,uint8_t *pdata,uint16_t datalen)
{
	volatile I2C_Stage state = I2C_READY;
	uint16_t status = 0;
	volatile uint16_t stopFlag = 0;
	volatile uint16_t cnt = 0;

	while(!(stopFlag)){
		switch(state){
			case I2C_READY:

//				if(I2C_isBusBusy(I2C_BASE))
				if(I2C_REGS.I2CSTR.bit.BB != 0)
				{
					return 1;
				}

//				I2C_setConfig(I2C_BASE, I2C_CONTROLLER_SEND_MODE);
				I2C_REGS.I2CMDR.bit.MST = 1;
				I2C_REGS.I2CMDR.bit.TRX = 1;

//				I2C_setTargetAddress(I2C_BASE, dev_addr);
				I2C_REGS.I2CSAR.bit.SAR = dev_addr;

//				I2C_setDataCount(I2C_BASE, datalen+1);
				I2C_REGS.I2CCNT.all = datalen+1;

				state = I2C_START;
				break;

			case I2C_START:

//				I2C_sendStartCondition(I2C_BASE);
				I2C_REGS.I2CMDR.bit.STT = 1;

//				I2C_putData(I2C_BASE,reg_addr);
				I2C_REGS.I2CDXR = reg_addr;

				state = I2C_TRANSFER;

				break;

			case I2C_TRANSFER:

				for(cnt = 0;cnt<datalen;cnt++){
					do{
//						status = I2C_getStatus(I2C_BASE);
						status = I2C_REGS.I2CSTR.all;

					}while(!(status & I2C_STS_TX_DATA_RDY));
//					I2C_putData(I2C_BASE,pdata[cnt]);
					I2C_REGS.I2CDXR = pdata[cnt];
				}

				state = I2C_STOP;

				break;

			case I2C_STOP:

//				I2C_sendStopCondition(I2C_BASE);
				I2C_REGS.I2CMDR.bit.STP = 1;

				stopFlag = 1;

				break;
		}
	}

	return 0;
}
