/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    cmpss_ex1_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#include "printf.h"
#include "cmpss_ex1_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define PWM1_TIMER_MIN     500U
#define PWM1_TIMER_MAX     8000U
#define EPWM_TIMER_UP      1U
#define EPWM_TIMER_DOWN    0U

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

#define CTRIPHFILCTL_SAMPWIN_VALUE 0
#define CTRIPHFILCTL_THRESH_VALUE 0

#define CTRIPLFILCTL_SAMPWIN_VALUE 0
#define CTRIPLFILCTL_THRESH_VALUE 0
#define CTRIPH_SAMPLE_PRESCALE_VALUE   0U
#define CTRIPL_SAMPLE_PRESCALE_VALUE   0U
#define EPWMSYNCPER_SELECT 1U
#define MAX_RAMP_VALUE 0u
#define DELAY_VALUE 0u
#define DECREMENT_VALUE 0u
/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */



/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/**
 * \brief   "Error function" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void error()
{

}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{


	PinMux_init();
	CMPSS_init();
	OUTPUTXBAR_init();


}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{

	ASysCtl_setAnaTopSpare(0, 0x0020);
	ASysCtl_setCmpSpare(0x20000000);

//	SysCtl_setAgpio21Sel(0x9);  //select CMP4_HP5 for pin AGPIO21
	//ASysCtl_setA8Sel(0x03);
	//ASysCtl_setC14Sel(0x02);    //select CMP4_HP
//	ASysCtl_setC3Sel(0x03);       //select CMP4_HN1 for pin C3
//	ASysCtl_setA2Sel(0x03);       //select A2_CMP1_HP0

	//
	// PinMux for modules assigned to CPU1
	//

	//
	// ANALOG -> myANALOGPinMux0 Pinmux
	//

	// Analog PinMux for A2/C9
	GPIO_setPinConfig(GPIO_224_GPIO224);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(224, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A4/C14
	GPIO_setPinConfig(GPIO_225_GPIO225);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(225, GPIO_ANALOG_ENABLED);
	// Analog PinMux for C6
	GPIO_setPinConfig(GPIO_226_GPIO226);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(226, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A9/C8
	GPIO_setPinConfig(GPIO_227_GPIO227);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(227, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A6
	GPIO_setPinConfig(GPIO_228_GPIO228);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(228, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A10/C10
	GPIO_setPinConfig(GPIO_230_GPIO230);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(230, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A0/C15
	GPIO_setPinConfig(GPIO_231_GPIO231);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(231, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A1
	GPIO_setPinConfig(GPIO_232_GPIO232);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(232, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A15/C7
	GPIO_setPinConfig(GPIO_233_GPIO233);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(233, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A11/C0
	GPIO_setPinConfig(GPIO_237_GPIO237);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(237, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A12/C1
	GPIO_setPinConfig(GPIO_238_GPIO238);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(238, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A14/C4
	GPIO_setPinConfig(GPIO_239_GPIO239);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(239, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A8/C11
	GPIO_setPinConfig(GPIO_241_GPIO241);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(241, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A3/C5
	GPIO_setPinConfig(GPIO_242_GPIO242);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(242, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A5/C2
	GPIO_setPinConfig(GPIO_244_GPIO244);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(244, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A7/C3
	GPIO_setPinConfig(GPIO_245_GPIO245);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(245, GPIO_ANALOG_ENABLED);

	// OUTPUTXBAR3 -> myOUTPUTXBAR0 Pinmux
	GPIO_setPinConfig(myOUTPUTXBAR0_OUTPUTXBAR_PIN_CONFIG);

    // Configure TRIP4 to be CTRIP1H using the ePWM X-BAR
    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX00_CMPSS1_CTRIPH);
    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX00);
}



//*****************************************************************************
//
// CMPSS Configurations
//
//*****************************************************************************
void CMPSS_init(){
	myCMPSS0_init();
}

void myCMPSS0_init(){
    // Select the value for CMP1HPMXSEL.
    ASysCtl_selectCMPHPMux(ASYSCTL_CMPHPMUX_SELECT_1,0U);

    // Select the value for CMP1LPMXSEL.
    ASysCtl_selectCMPLPMux(ASYSCTL_CMPLPMUX_SELECT_1,0U);

    // Sets the configuration for the high comparator.
	Cmpss1Regs.COMPCTL.bit.COMPHSOURCE = COMPHSOURCE_INTERN_DAC;

    // Sets the configuration for the low comparator.
	Cmpss1Regs.COMPCTL.bit.COMPLSOURCE = COMPLSOURCE_INTERN_DAC;


    // Sets the configuration for the internal comparator DACs.
    Cmpss1Regs.COMPDACHCTL.bit.DACSOURCE = UPDATE_FORM_DACHVALS;
    Cmpss1Regs.COMPDACHCTL.bit.SELREF = DACREF_VDDA_ENABLE;
    Cmpss1Regs.COMPDACHCTL.bit.SWLOADSEL= UPDATE_DACxVALS_SYSCLK;

    // Sets the value of the internal DAC of the high comparator.
    Cmpss1Regs.DACHVALS.bit.DACVAL = 2048U;

    // Sets the value of the internal DAC of the low comparator.
    Cmpss1Regs.DACLVALS.bit.DACVAL = 0U;

    //  Configures the digital filter of the high comparator.
    Cmpss1Regs.CTRIPHFILCTL.bit.SAMPWIN = CTRIPHFILCTL_SAMPWIN_VALUE;
    Cmpss1Regs.CTRIPHFILCTL.bit.THRESH = CTRIPHFILCTL_THRESH_VALUE;
	Cmpss1Regs.CTRIPHFILCLKCTL = CTRIPH_SAMPLE_PRESCALE_VALUE;

    // Configures the digital filter of the low comparator.
    Cmpss1Regs.CTRIPLFILCTL.bit.SAMPWIN = CTRIPLFILCTL_SAMPWIN_VALUE;
    Cmpss1Regs.CTRIPLFILCTL.bit.THRESH = CTRIPLFILCTL_THRESH_VALUE;
    Cmpss1Regs.CTRIPLFILCLKCTL = CTRIPL_SAMPLE_PRESCALE_VALUE;

    // Sets the output signal configuration for the high comparator.
	Cmpss1Regs.COMPCTL.bit.CTRIPHSEL = TRIP_SYNCHRONOUS_COMP;
    Cmpss1Regs.COMPCTL.bit.CTRIPOUTHSEL = TRIPOUT_SYNCHRONOUS_COMP;
    
    // Sets the output signal configuration for the low comparator.
    Cmpss1Regs.COMPCTL.bit.CTRIPLSEL = TRIP_ASYNCHRONOUS_COMP;
    Cmpss1Regs.COMPCTL.bit.CTRIPOUTLSEL = TRIPOUT_ASYNCHRONOUS_COMP;

    // Sets the comparator hysteresis settings.
//    AnalogSubsysRegs.CMP1_H_TRIM.bit.CMP1_H_TRIM = 2;
//    AnalogSubsysRegs.CMP1_L_TRIM.bit.CMP1_L_TRIM = 2;
    Cmpss1Regs.COMPHYSCTL.bit.COMPHYS = 0;

    // Configures the high comparator subsystem's ramp generator.
    Cmpss1Regs.COMPDACHCTL.bit.RAMPSOURCE = EPWMSYNCPER_SELECT;
    Cmpss1Regs.COMPDACHCTL.bit.RAMPLOADSEL = CMPSS_RAMPLOADSEL_ENABLE;
	Cmpss1Regs.RAMPHREFS = MAX_RAMP_VALUE;
	Cmpss1Regs.RAMPHSTEPVALS = DECREMENT_VALUE;
	Cmpss1Regs.RAMPHDLYS.bit.DELAY = DELAY_VALUE;

    // Disables reset of HIGH comparator digital filter output latch on PWMSYNC
	Cmpss1Regs.COMPSTSCLR.bit.HSYNCCLREN = EPWMSYNCPER_NOT_RESET_LATCH;

    // Disables reset of LOW comparator digital filter output latch on PWMSYNC
	Cmpss1Regs.COMPSTSCLR.bit.LSYNCCLREN = EPWMSYNCPER_NOT_RESET_LATCH;

    // Sets the ePWM module blanking signal that holds trip in reset.
	Cmpss1Regs.COMPDACHCTL.bit.BLANKSOURCE = 0;

    // Disables an ePWM blanking signal from holding trip in reset.
	Cmpss1Regs.COMPDACHCTL.bit.BLANKEN = EPWMBLANK_DISABLE;

    // Configures whether or not the digital filter latches are reset by PWMSYNC
	Cmpss1Regs.COMPSTSCLR.bit.HSYNCCLREN = 0;
//	Cmpss1Regs.COMPSTSCLR.bit.LSYNCCLREN = 0;

    // Enables the CMPSS module.
    Cmpss1Regs.COMPCTL.bit.COMPDACE = 1;

    // Delay for CMPSS DAC to power up.
    DEVICE_DELAY_US(500);
}

//*****************************************************************************
//
// OUTPUTXBAR Configurations
//
//*****************************************************************************
void OUTPUTXBAR_init(){
	myOUTPUTXBAR0_init();
}

void myOUTPUTXBAR0_init(){
	XBAR_setOutputLatchMode(OUTPUTXBAR_BASE, myOUTPUTXBAR0, false);
	XBAR_invertOutputSignal(OUTPUTXBAR_BASE, myOUTPUTXBAR0, false);

	//Mux configuration
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, myOUTPUTXBAR0, XBAR_OUT_MUX00_CMPSS1_CTRIPOUTH);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, myOUTPUTXBAR0, XBAR_MUX00);
}
/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif
