/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef SDFM_SYNC_FIFOREAD_H_
#define SDFM_SYNC_FIFOREAD_H_

#include "device.h"

#ifdef __cplusplus
extern "C"{
#endif


//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************
//
// SDFM1 SD1_C1 - GPIO Settings
//
#define SD1_C1_PIN             17
#define SD1_C1_PIN_MUX         GPIO_17_SD1_C1

//
// SDFM1 SD1_D1 - GPIO Settings
//
#define SD1_D1_PIN             16
#define SD1_D1_PIN_MUX         GPIO_16_SD1_D1

//
// SDFM1 SD1_C2 - GPIO Settings
//
#define SD1_C2_PIN             19
#define SD1_C2_PIN_MUX         GPIO_19_SD1_C2

//
// SDFM1 SD1_D2 - GPIO Settings
//
#define SD1_D2_PIN             32
#define SD1_D2_PIN_MUX         GPIO_32_SD1_D2

//
// SDFM1 SD1_C3 - GPIO Settings
//
#define SD1_C3_PIN             21
#define SD1_C3_PIN_MUX         GPIO_21_SD1_C3

//
// SDFM1 SD1_D3 - GPIO Settings
//
#define SD1_D3_PIN             20
#define SD1_D3_PIN_MUX         GPIO_20_SD1_D3

//
// SDFM1 SD1_C4 - GPIO Settings
//
#define SD1_C4_PIN             23
#define SD1_C4_PIN_MUX         GPIO_23_SD1_C4

//
// SDFM1 SD1_D4 - GPIO Settings
//
#define SD1_D4_PIN             22
#define SD1_D4_PIN_MUX         GPIO_22_SD1_D4

//--------------SDFM2--------------
//
// SDFM2 SD2_C1 - GPIO Settings
//
#define SD2_C1_PIN             25
#define SD2_C1_PIN_MUX         GPIO_25_SD2_C1

//
// SDFM2 SD2_D1 - GPIO Settings
//
#define SD2_D1_PIN             24
#define SD2_D1_PIN_MUX         GPIO_24_SD2_D1

//
// SDFM2 SD2_C2 - GPIO Settings
//
#define SD2_C2_PIN             27
#define SD2_C2_PIN_MUX         GPIO_27_SD2_C2

//
// SDFM2 SD2_D2 - GPIO Settings
//
#define SD2_D2_PIN             26
#define SD2_D2_PIN_MUX         GPIO_26_SD2_D2

//
// SDFM2 SD2_C3 - GPIO Settings
//
#define SD2_C3_PIN             29
#define SD2_C3_PIN_MUX         GPIO_29_SD2_C3

//
// SDFM2 SD2_D3 - GPIO Settings
//
#define SD2_D3_PIN             28
#define SD2_D3_PIN_MUX         GPIO_28_SD2_D3

//
// SDFM2 SD2_C4 - GPIO Settings
//
#define SD2_C4_PIN             31
#define SD2_C4_PIN_MUX         GPIO_31_SD2_C4

//
// SDFM2 SD2_D4 - GPIO Settings
//
#define SD2_D4_PIN             30
#define SD2_D4_PIN_MUX         GPIO_30_SD2_D4


#define MAX_SAMPLES            1024
#define SDFM_BASE              SDFM1_BASE
#define FIFO_INT_NUMBER        10

void pinmux_init(void);
void sdfm_init(uint32_t base);

void sdfm1_D1_FIFO_ISR(void);
void sdfm1_D2_FIFO_ISR(void);
void sdfm1_D3_FIFO_ISR(void);
void sdfm1_D4_FIFO_ISR(void);

void sdfm2_D1_FIFO_ISR(void);
void sdfm2_D2_FIFO_ISR(void);
void sdfm2_D3_FIFO_ISR(void);
void sdfm2_D4_FIFO_ISR(void);

#ifdef __cplusplus
}
#endif


#endif /* SDFM_SYNC_FIFOREAD_H_ */
