/*
 * bootrom_PIN.h
 *
 *  Created on: 2025 May 10
 *      Author: 13370
 */

#ifndef BOOTROM_PIN_H_
#define BOOTROM_PIN_H_

#include "nmsis_gcc.h"

#define BOOTROM_ENABLE_TABLE_KEY		0x5a5a5a5a

typedef struct {
	uint16_t Version;
	uint16_t Chip_ID;
	uint16_t UART_number;
	uint16_t CAN_number;
	uint32_t UART_TX_PINMUX_Value;
	uint32_t UART_RX_PINMUX_Value;
	uint16_t UART_TX_PIN_NUM_Value;
	uint16_t UART_RX_PIN_NUM_Value;
	uint32_t CAN_TX_PINMUX_Value;
	uint32_t CAN_RX_PINMUX_Value;
	uint16_t CAN_TX_PIN_NUM_Value;
	uint16_t CAN_RX_PIN_NUM_Value;
	uint32_t CAN_TX_ID;
	uint32_t CAN_RX_ID;
	uint32_t ENABLE_TABLE;
	struct {
		uint16_t UART_ENABLE	:	1;
		uint16_t CAN_ENABLE		:	1;
		uint16_t RESERVED		:	14;
	};
	uint16_t TABLE_SIZE;
} bootromPIN_t;

#endif /* BOOTROM_PIN_H_ */
