/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifndef BOOTLOADER_CAN_H
#define BOOTLOADER_CAN_H

//
// Includes
//
#include "bootrom_select_bootmode.h"
#include "device.h"

//
// Defines
//
#define CAN_BOOT_DEFAULT_BIT_TIMING     0x0U
#define CAN_BOOT_USE_XTAL               0x1U
#define CAN_CLK_DIVIDE_BY_10            0x5U
#define CAN_CLK_DIVIDE_BY_1             0x0U

#define CAN_MSG_MAX_LEN		CAN_DATA_LENGTH_8
#define CAN_CTRL_TX_ID		0x456
#define CAN_CTRL_RX_ID		0x123
//
//Function Prototype
//
extern uint32_t DCAN_Boot(uint32_t bootMode);

#endif // BOOTLOADER_CAN_H
