/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_BOARD_CFG_H__
#define __BOOT_BOARD_CFG_H__

/* ʹⲿپ */
#define __BOOT_HSE_ENABLE				1

/* ⲿ: 0 Դ, 1 Դ */
#define __BOOT_HSE_CLOCK_TYPE			0

/* 趨PLLʱԴƵ: 10MHz IRC10MHz/20MHzⲿ */
#if __BOOT_HSE_ENABLE == 0
	#define BOOT_OSCSRC_FREQ			(10*1000*1000U)
#else
	#define BOOT_OSCSRC_FREQ			(20*1000*1000U)
#endif

/* ϵͳʱ 120MHz240MHz360MHz */
#define BOOT_SYSCLK_FREQ				(240*1000*1000U)

/* ϵͳʱӷƵ */
#define BOOT_SYSCLK_DIV					(2)

/* PLLʱ */
#define BOOT_PLLCLK_FREQ				(BOOT_SYSCLK_FREQ * BOOT_SYSCLK_DIV)

/* AHBʱӷƵ */
#define BOOT_AHBCLK_DIV					(2)

/* AHBʱӵϵͳʱ */
#define BOOT_AHBCLK_FREQ				(BOOT_SYSCLK_FREQ / BOOT_AHBCLK_DIV)

/* APBʱӷƵ = 1248 */
#define BOOT_APBCLK_DIV					(4)

/* APBʱƵ MHz */
#define BOOT_APBCLK_FREQ				(BOOT_SYSCLK_FREQ / BOOT_APBCLK_DIV)

/* ʱʱƵʵAPBʱƵ */
#define BOOT_SOC_TIMER_FREQ				(BOOT_APBCLK_FREQ)

#endif
