/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"

#include "msg_memory.h"
#include "uart_dev.h"
#include "can_transfer.h"
#include "spi_dev.h"

int main(void)
{
	Device_init();

	__disable_irq();

	mem_init_status();

	Uart_Init();

	spi_init();

	can_ctrl_init();

	__enable_irq();

	GPIO_setDirectionMode(6,GPIO_DIR_MODE_IN);
	GPIO_setDirectionMode(10,GPIO_DIR_MODE_IN);

	while (1) {
		if ((GPIO_ReadPin(6) == 1) && (GPIO_ReadPin(10) == 0)) {
			uart_transmit_spi_msg();
			spi_transmit_uart_msg();
		} else if ((GPIO_ReadPin(6) == 0) && (GPIO_ReadPin(10) == 0)) {
			uart_transmit_can_msg();
			can_transmit_uart_msg();
		} else if ((GPIO_ReadPin(6) == 0) && (GPIO_ReadPin(10) == 1)) {
			continue;
		} else {
			continue;
		}
	}
}
