/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_ASYSCTL_V1_2_H__
#define __BOOT_ASYSCTL_V1_2_H__

#ifdef __cplusplus
extern "C"{
#endif

#if (GS32F00xx == 0x1200)

#include "boot_hw_type.h"
#include "inc/hw_memmap.h"
#include "inc/hw_asysctl_v12.h"

#define BOOT_FUNCTION

BOOT_TEXT void boot_sysctl_set_ldo_test_mode(uint32_t mode);

BOOT_TEXT void boot_sysctl_set_ldo_chop_enable(uint32_t en);

BOOT_TEXT void boot_sysctl_set_ldo_1v2_trim(void);

BOOT_TEXT void boot_sysctl_set_ana_ldo_trim(void);

BOOT_TEXT void boot_sysctl_set_top_bor_trim(void);

BOOT_TEXT void boot_sysctl_set_osc1_trim(void);

BOOT_TEXT void boot_sysctl_set_osc2_trim(void);

#endif /* GS32F00xx */

#ifdef __cplusplus
}
#endif

#endif
