/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_GPIO_V2_2_H__
#define __BOOT_GPIO_V2_2_H__

#ifdef __cplusplus
extern "C"{
#endif

#if ((GS32F3xx == 0x2200) ||(GS32F3xx == 0x2203))

#include "boot_hw_type.h"
#include "inc/hw_sysctl_dig_v22.h"
#include "sysctl_io_v12.h"
#include "sysctl/sysctl_pinmux_v12.h"
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"

typedef enum {
	BOOT_GPIO_PIN_TYPE_STD			= 0,
	BOOT_GPIO_PIN_TYPE_PULLUP		= 1,
	BOOT_GPIO_PIN_TYPE_INVERT		= 2,
	BOOT_GPIO_PIN_TYPE_PULLDOWN		= 4,
	BOOT_GPIO_PIN_TYPE_SCHMITT		= 8,
} Boot_Gpio_Pin_Type_t;

BOOT_TEXT void boot_gpio_set_clk_ref(GPIO_ClkRefMode mode);

BOOT_TEXT void boot_gpio_set_pin_config(uint32_t pinConfig);

BOOT_TEXT void boot_gpio_set_analog_mode(uint32_t pin, GPIO_AnalogMode mode);

BOOT_TEXT void boot_gpio_set_pad_config(uint32_t pin, uint32_t pinType);

BOOT_TEXT uint16_t boot_gpio_read_pin(uint16_t pin);

BOOT_TEXT void boot_gpio_set_qualification_mode(uint32_t pin, GPIO_QualificationMode qualification);

#endif

#ifdef __cplusplus
}
#endif

#endif
