/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_HW_TYPE_H__
#define __BOOT_HW_TYPE_H__

#ifdef __cplusplus
extern "C"{
#endif

#include <stdint.h>
#include <stdbool.h>

#include "inc/hw_types.h"

// #ifndef uintptr_t
// #define uintptr_t unsigned long
// #endif

// #ifndef uint64_t
// #define uint64_t unsigned long long
// #endif

// #ifndef uint32_t
// #define uint32_t unsigned int
// #endif

// #ifndef uint16_t
// #define uint16_t unsigned short
// #endif

// #ifndef uint8_t
// #define uint8_t unsigned char
// #endif

// #ifndef int32_t
// #define int32_t int
// #endif

// #ifndef int16_t
// #define int16_t short
// #endif

// #ifndef int8_t
// #define int8_t char
// #endif

#ifndef BOOT_DATA
#define BOOT_DATA __attribute__((section(".boot_data_section")))
#endif

#ifndef BOOT_BSS
#define BOOT_BSS __attribute__((section(".boot_bss_section")))
#endif

#ifndef BOOT_TEXT
#define BOOT_TEXT __attribute__((section(".boot_text_section")))
#endif

#ifndef BOOT_RAM
#define BOOT_RAM __attribute__((section(".boot_rom_to_ram_section")))
#endif

#ifndef NULL
#define NULL 0
#endif

#ifdef __cplusplus
}
#endif

#endif
