/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_IRQ_NUM_V1_2_H__
#define __BOOT_IRQ_NUM_V1_2_H__

#ifdef __cplusplus
extern "C"{
#endif

#if (GS32F00xx == 0x1200)

typedef enum BOOT_IRQn {
	BOOT_Invalid_IRQn			= -1,

	BOOT_Reserved0_IRQn			= 0,			/* Internal reserved */
	BOOT_Reserved1_IRQn			= 1,			/* Internal reserved */
	BOOT_Reserved2_IRQn			= 2,			/* Internal reserved */
	BOOT_SysTimerSW_IRQn		= 3,			/* System Timer SW interrupt */
	BOOT_Reserved3_IRQn			= 4,			/* Internal reserved */
	BOOT_Reserved4_IRQn			= 5,			/* Internal reserved */
	BOOT_Reserved5_IRQn			= 6,			/* Internal reserved */
	BOOT_SysTimer_IRQn			= 7,			/* System Timer Interrupt */
	BOOT_Reserved6_IRQn			= 8,			/* Internal reserved */
	BOOT_Reserved7_IRQn			= 9,			/* Internal reserved */
	BOOT_Reserved8_IRQn			= 10,			/* Internal reserved */
	BOOT_Reserved9_IRQn			= 11,			/* Internal reserved */
	BOOT_Reserved10_IRQn		= 12,			/* Internal reserved */
	BOOT_Reserved11_IRQn		= 13,			/* Internal reserved */
	BOOT_Reserved12_IRQn		= 14,			/* Internal reserved */
	BOOT_Reserved13_IRQn		= 15,			/* Internal reserved */
	BOOT_InterCore_IRQn			= 16,			/* CIDU Inter Core Interrupt */
	BOOT_Reserved15_IRQn		= 17,			/* Internal reserved */
	BOOT_Reserved16_IRQn		= 18,			/* Internal reserved */

	/**
	 * ToDo: add here your device specific external interrupt numbers. 19~1023 is reserved number
	 * for user. Maxmum interrupt supported could get from clicinfo.NUM_INTERRUPT. According the
	 * interrupt handlers defined in startup_Device.seg.: Interrupt for Timer#1
	 * eclic_tim1_handler -> TIM1_IRQn
	 */
	BOOT_INT_MU_TX16			= 19,
	BOOT_INT_MU_TX15			= 20,
	BOOT_INT_MU_TX14			= 21,
	BOOT_INT_MU_TX13			= 22,
	BOOT_INT_MU_TX12			= 23,
	BOOT_INT_MU_TX11			= 24,
	BOOT_INT_MU_TX10			= 25,
	BOOT_INT_MU_TX9				= 26,
	BOOT_INT_MU_TX8				= 27,
	BOOT_INT_MU_TX7				= 28,
	BOOT_INT_MU_TX6				= 29,
	BOOT_INT_MU_TX5				= 30,
	BOOT_INT_MU_TX4				= 31,
	BOOT_INT_MU_TX3				= 32,
	BOOT_INT_MU_TX2				= 33,
	BOOT_INT_MU_TX1				= 34,
	BOOT_INT_MU_RX16			= 35,
	BOOT_INT_MU_RX15			= 36,
	BOOT_INT_MU_RX14			= 37,
	BOOT_INT_MU_RX13			= 38,
	BOOT_INT_MU_RX12			= 39,
	BOOT_INT_MU_RX11			= 40,
	BOOT_INT_MU_RX10			= 41,
	BOOT_INT_MU_RX9				= 42,
	BOOT_INT_MU_RX8				= 43,
	BOOT_INT_MU_RX7				= 44,
	BOOT_INT_MU_RX6				= 45,
	BOOT_INT_MU_RX5				= 46,
	BOOT_INT_MU_RX4				= 47,
	BOOT_INT_MU_RX3				= 48,
	BOOT_INT_MU_RX2				= 49,
	BOOT_INT_MU_RX1				= 50,

	BOOT_INT_SLV_RST_FINISH		= 55,
	BOOT_INT_DSP_M_FAIL			= 56,

	/* memory self-test completed */
	BOOT_INT_STC				= 61,
	BOOT_INT_EPG				= 62,

	BOOT_INT_RTOSINT1			= 66,
	BOOT_INT_FPU_IO				= 67,
	BOOT_INT_FPU_DZ				= 68,
	BOOT_INT_FPU_ID				= 69,
	BOOT_INT_FPU_IX				= 70,
	BOOT_INT_FPU_UNDERFLOW		= 71,
	BOOT_INT_FPU_OVERFLOW		= 72,

	BOOT_INT_AES				= 75,
	BOOT_INT_WINDOW_FFT			= 76,
	BOOT_INT_FFT				= 77,
	BOOT_INT_CRC				= 78,
	BOOT_INT_DBUS				= 79,
	BOOT_INT_IBUS				= 80,
	BOOT_INT_EFC_DONE			= 81,
	BOOT_INT_EFC				= 82,

	BOOT_INT_XINT16				= 85,
	BOOT_INT_XINT15				= 86,
	BOOT_INT_XINT14				= 87,
	BOOT_INT_XINT13				= 88,
	BOOT_INT_XINT12				= 89,
	BOOT_INT_XINT11				= 90,
	BOOT_INT_XINT10				= 91,
	BOOT_INT_XINT9				= 92,
	BOOT_INT_XINT8				= 93,
	BOOT_INT_XINT7				= 94,
	BOOT_INT_XINT6				= 95,
	BOOT_INT_XINT5				= 96,
	BOOT_INT_XINT4				= 97,
	BOOT_INT_XINT3				= 98,

	BOOT_INT_ADCC4				= 103,
	BOOT_INT_ADCC3				= 104,
	BOOT_INT_ADCC2				= 105,
	BOOT_INT_ADCC_EVT			= 106,
	BOOT_INT_ADCB4				= 107,
	BOOT_INT_ADCB3				= 108,
	BOOT_INT_ADCB2				= 109,
	BOOT_INT_ADCB_EVT			= 110,
	BOOT_INT_ADCA4				= 111,
	BOOT_INT_ADCA3				= 112,
	BOOT_INT_ADCA2				= 113,
	BOOT_INT_ADCA_EVT			= 114,

	BOOT_INT_PMBUSA_ALERT		= 117,
	BOOT_INT_PMBUSA				= 118,

	BOOT_INT_GPIO				= 121,
	BOOT_INT_QSPI				= 122,

	BOOT_INT_CANB				= 125,
	BOOT_INT_CANA				= 126,

	BOOT_INT_SCIB				= 129,
	BOOT_INT_SCIA				= 130,
	BOOT_INT_LINB				= 131,
	BOOT_INT_LINA				= 132,
	BOOT_INT_USER12				= 133,
	BOOT_INT_USER11				= 134,
	BOOT_INT_USER10				= 135,
	BOOT_INT_USER9				= 136,
	BOOT_INT_USER8				= 137,
	BOOT_INT_USER7				= 138,
	BOOT_INT_USER6				= 139,
	BOOT_INT_USER5				= 140,
	BOOT_INT_USER4				= 141,
	BOOT_INT_USER3				= 142,
	BOOT_INT_USER2				= 143,
	BOOT_INT_USER1				= 144,
	BOOT_INT_I2C1				= 145,
	BOOT_INT_I2C0				= 146,
	BOOT_INT_DMA1_CH8			= 147,
	BOOT_INT_DMA1_CH7			= 148,
	BOOT_INT_DMA1_CH6			= 149,
	BOOT_INT_DMA1_CH5			= 150,
	BOOT_INT_DMA1_CH4			= 151,
	BOOT_INT_DMA1_CH3			= 152,
	BOOT_INT_DMA1_CH2			= 153,
	BOOT_INT_DMA1_CH1			= 154,
	BOOT_INT_DMA2_CH8			= 155,
	BOOT_INT_DMA2_CH7			= 156,
	BOOT_INT_DMA2_CH6			= 157,
	BOOT_INT_DMA2_CH5			= 158,
	BOOT_INT_DMA2_CH4			= 159,
	BOOT_INT_DMA2_CH3			= 160,
	BOOT_INT_DMA2_CH2			= 161,
	BOOT_INT_DMA2_CH1			= 162,
	BOOT_INT_SDFM2DR4			= 163,
	BOOT_INT_SDFM2DR3			= 164,
	BOOT_INT_SDFM2DR2			= 165,
	BOOT_INT_SDFM2DR1			= 166,

	BOOT_INT_DMA2_MUX			= 168,
	BOOT_INT_DMA1_MUX			= 169,

	BOOT_INT_TIMER3				= 172,
	BOOT_INT_TIMER2				= 173,
	BOOT_INT_TIMER1				= 174,

	BOOT_INT_SPIB				= 177,
	BOOT_INT_SPIA				= 178,
	BOOT_INT_SDFM1DR4			= 179,
	BOOT_INT_SDFM1DR3			= 180,
	BOOT_INT_SDFM1DR2			= 181,
	BOOT_INT_SDFM1DR1			= 182,

	BOOT_INT_SDFM2				= 184,
	BOOT_INT_SDFM1				= 185,

	BOOT_INT_CLB4				= 189,
	BOOT_INT_CLB3				= 190,
	BOOT_INT_CLB2				= 191,
	BOOT_INT_CLB1				= 192,
	BOOT_INT_EQEP2				= 193,
	BOOT_INT_EQEP1				= 194,
	BOOT_INT_ECAP7_2			= 195,
	BOOT_INT_ECAP6_2			= 196,
	BOOT_INT_ECAP3_2			= 197,

	BOOT_INT_ECAP7				= 204,
	BOOT_INT_ECAP6				= 205,
	BOOT_INT_ECAP5				= 206,
	BOOT_INT_ECAP4				= 207,
	BOOT_INT_ECAP3				= 208,
	BOOT_INT_ECAP2				= 209,
	BOOT_INT_ECAP1				= 210,

	BOOT_INT_EPWM12				= 215,
	BOOT_INT_EPWM11				= 216,
	BOOT_INT_EPWM10				= 217,
	BOOT_INT_EPWM9				= 218,
	BOOT_INT_EPWM8				= 219,
	BOOT_INT_EPWM7				= 220,
	BOOT_INT_EPWM6				= 221,
	BOOT_INT_EPWM5				= 222,
	BOOT_INT_EPWM4				= 223,
	BOOT_INT_EPWM3				= 224,
	BOOT_INT_EPWM2				= 225,
	BOOT_INT_EPWM1				= 226,

	BOOT_INT_EPWM12_TZ			= 231,
	BOOT_INT_EPWM11_TZ			= 232,
	BOOT_INT_EPWM10_TZ			= 233,
	BOOT_INT_EPWM9_TZ			= 234,
	BOOT_INT_EPWM8_TZ			= 235,
	BOOT_INT_EPWM7_TZ			= 236,
	BOOT_INT_EPWM6_TZ			= 237,
	BOOT_INT_EPWM5_TZ			= 238,
	BOOT_INT_EPWM4_TZ			= 239,
	BOOT_INT_EPWM3_TZ			= 240,
	BOOT_INT_EPWM2_TZ			= 241,
	BOOT_INT_EPWM1_TZ			= 242,
	BOOT_INT_MU_RESET			= 243,
	BOOT_INT_MU_GENERAL			= 244,
	BOOT_INT_MU_TX_IRQn			= 245,
	BOOT_INT_MU_RX_IRQn			= 246,
	BOOT_INT_DSP_WWDG			= 247,
	BOOT_INT_SYS_ERR			= 249,
	BOOT_INT_DSP_WDG			= 250,
	BOOT_INT_TIMER0				= 252,
	BOOT_INT_WAKE				= 253,
	BOOT_INT_XINT2				= 254,
	BOOT_INT_XINT1				= 255,
	BOOT_INT_ADCC1				= 256,
	BOOT_INT_ADCB1				= 257,
	BOOT_INT_ADCA1				= 258,

	BOOT_SOC_INT_MAX,
} BOOT_IRQn_t;

#endif		/* end of (GS32F00xx == 0x3000) */

#ifdef __cplusplus
}
#endif

#endif
