/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_IRQ_NUM_V3_0_H__
#define __BOOT_IRQ_NUM_V3_0_H__

#ifdef __cplusplus
extern "C"{
#endif

#if (GS32F00xx == 0x3000)

typedef enum BOOT_IRQn {
	BOOT_Invalid_IRQn			= -1,

	BOOT_Reserved0_IRQn			= 0,			/* Internal reserved */
	BOOT_Reserved1_IRQn			= 1,			/* Internal reserved */
	BOOT_Reserved2_IRQn			= 2,			/* Internal reserved */
	BOOT_SysTimerSW_IRQn		= 3,			/* System Timer SW interrupt */
	BOOT_Reserved3_IRQn			= 4,			/* Internal reserved */
	BOOT_Reserved4_IRQn			= 5,			/* Internal reserved */
	BOOT_Reserved5_IRQn			= 6,			/* Internal reserved */
	BOOT_SysTimer_IRQn			= 7,			/* System Timer Interrupt */
	BOOT_Reserved6_IRQn			= 8,			/* Internal reserved */
	BOOT_Reserved7_IRQn			= 9,			/* Internal reserved */
	BOOT_Reserved8_IRQn			= 10,			/* Internal reserved */
	BOOT_Reserved9_IRQn			= 11,			/* Internal reserved */
	BOOT_Reserved10_IRQn		= 12,			/* Internal reserved */
	BOOT_Reserved11_IRQn		= 13,			/* Internal reserved */
	BOOT_Reserved12_IRQn		= 14,			/* Internal reserved */
	BOOT_Reserved13_IRQn		= 15,			/* Internal reserved */
	BOOT_InterCore_IRQn			= 16,			/* CIDU Inter Core Interrupt */
	BOOT_Reserved15_IRQn		= 17,			/* Internal reserved */
	BOOT_Reserved16_IRQn		= 18,			/* Internal reserved */

	/**
	 * ToDo: add here your device specific external interrupt numbers. 19~1023 is reserved number
	 * for user. Maxmum interrupt supported could get from clicinfo.NUM_INTERRUPT. According the
	 * interrupt handlers defined in startup_Device.seg.: Interrupt for Timer#1
	 * eclic_tim1_handler -> TIM1_IRQn
	 */
	BOOT_INT_MCANB_ECC_NMI		= 45,
	BOOT_INT_MCANB_ECC_ERR		= 46,
	BOOT_INT_MCANB_TS			= 47,
	BOOT_INT_MCANA_ECC_NMI		= 48,
	BOOT_INT_MCANA_ECC_ERR		= 49,
	BOOT_INT_MCANA_TS			= 50,

	BOOT_INT_JTAG_AUTH			= 51,
	BOOT_INT_JTAG_INFO			= 52,

	BOOT_INT_EPG				= 62,

	BOOT_INT_RTOSINT1			= 66,

	BOOT_INT_AES				= 75,

	BOOT_INT_CRC				= 78,

	BOOT_INT_EFC_DONE			= 81,
	BOOT_INT_EFC_SEC			= 82,

	BOOT_INT_XINT16				= 85,
	BOOT_INT_XINT15				= 86,
	BOOT_INT_XINT14				= 87,
	BOOT_INT_XINT13				= 88,
	BOOT_INT_XINT12				= 89,
	BOOT_INT_XINT11				= 90,
	BOOT_INT_XINT10				= 91,
	BOOT_INT_XINT9				= 92,
	BOOT_INT_XINT8				= 93,
	BOOT_INT_XINT7				= 94,
	BOOT_INT_XINT6				= 95,
	BOOT_INT_XINT5				= 96,
	BOOT_INT_XINT4				= 97,
	BOOT_INT_XINT3				= 98,

	BOOT_INT_ADCC4				= 103,
	BOOT_INT_ADCC3				= 104,
	BOOT_INT_ADCC2				= 105,
	BOOT_INT_ADCC_EVT			= 106,

	BOOT_INT_ADCA4				= 111,
	BOOT_INT_ADCA3				= 112,
	BOOT_INT_ADCA2				= 113,
	BOOT_INT_ADCA_EVT			= 114,

	BOOT_INT_PMBUSA_ALERT		= 117,
	BOOT_INT_PMBUSA				= 118,
	BOOT_INT_I2CB_FIFO			= 119,
	BOOT_INT_I2CA_FIFO			= 120,

	BOOT_INT_GPIO				= 121,
	BOOT_INT_FSMC				= 122,

	BOOT_INT_SCIC_TX			= 125,
	BOOT_INT_SCIC_RX			= 126,
	BOOT_INT_SCIB_TX			= 127,
	BOOT_INT_SCIB_RX			= 128,
	BOOT_INT_SCIA_TX			= 129,
	BOOT_INT_SCIA_RX			= 130,

	BOOT_INT_LINB				= 131,
	BOOT_INT_LINA				= 132,
	BOOT_INT_USER12				= 133,
	BOOT_INT_USER11				= 134,
	BOOT_INT_USER10				= 135,
	BOOT_INT_USER9				= 136,
	BOOT_INT_USER8				= 137,
	BOOT_INT_USER7				= 138,
	BOOT_INT_USER6				= 139,
	BOOT_INT_USER5				= 140,
	BOOT_INT_USER4				= 141,
	BOOT_INT_USER3				= 142,
	BOOT_INT_USER2				= 143,
	BOOT_INT_USER1				= 144,

	BOOT_INT_I2CB				= 145,
	BOOT_INT_I2CA				= 146,

	BOOT_INT_DMA1_CH6			= 149,
	BOOT_INT_DMA1_CH5			= 150,
	BOOT_INT_DMA1_CH4			= 151,
	BOOT_INT_DMA1_CH3			= 152,
	BOOT_INT_DMA1_CH2			= 153,
	BOOT_INT_DMA1_CH1			= 154,

	BOOT_INT_SDFM1DR5			= 162,
	BOOT_INT_SDFM2DR4			= 163,
	BOOT_INT_SDFM2DR3			= 164,
	BOOT_INT_SDFM2DR2			= 165,
	BOOT_INT_SDFM2DR1			= 166,

	BOOT_INT_DMAMUX1_OVERFLOW	= 169,

	BOOT_INT_TIMER1				= 174,
	BOOT_INT_SPIB_TX			= 175,
	BOOT_INT_SPIB_RX			= 176,
	BOOT_INT_SPIA_TX			= 177,
	BOOT_INT_SPIA_RX			= 178,
	BOOT_INT_SDFM1DR4			= 179,
	BOOT_INT_SDFM1DR3			= 180,
	BOOT_INT_SDFM1DR2			= 181,
	BOOT_INT_SDFM1DR1			= 182,

	BOOT_INT_SDFM2				= 184,
	BOOT_INT_SDFM1				= 185,

	BOOT_INT_ENC2				= 189,
	BOOT_INT_ENC1				= 190,
	BOOT_INT_CLB2				= 191,
	BOOT_INT_CLB1				= 192,
	BOOT_INT_EQEP2				= 193,
	BOOT_INT_EQEP1				= 194,

	BOOT_INT_ECAP3_2			= 197,

	BOOT_INT_EQEP3				= 200,

	BOOT_INT_ECAP3				= 208,
	BOOT_INT_ECAP2				= 209,
	BOOT_INT_ECAP1				= 210,
	BOOT_INT_CANB1				= 211,
	BOOT_INT_CANB0				= 212,
	BOOT_INT_CANA1				= 213,
	BOOT_INT_CANA0				= 214,

	BOOT_INT_EPWM8				= 219,
	BOOT_INT_EPWM7				= 220,
	BOOT_INT_EPWM6				= 221,
	BOOT_INT_EPWM5				= 222,
	BOOT_INT_EPWM4				= 223,
	BOOT_INT_EPWM3				= 224,
	BOOT_INT_EPWM2				= 225,
	BOOT_INT_EPWM1				= 226,

	BOOT_INT_EPWM8_TZ			= 235,
	BOOT_INT_EPWM7_TZ			= 236,
	BOOT_INT_EPWM6_TZ			= 237,
	BOOT_INT_EPWM5_TZ			= 238,
	BOOT_INT_EPWM4_TZ			= 239,
	BOOT_INT_EPWM3_TZ			= 240,
	BOOT_INT_EPWM2_TZ			= 241,
	BOOT_INT_EPWM1_TZ			= 242,

	BOOT_INT_DSP_WWDG			= 247,

	BOOT_INT_SYS_ERR			= 249,
	BOOT_INT_DSP_WDG			= 250,

	BOOT_INT_TIMER0				= 252,
	BOOT_INT_WAKE				= 253,
	BOOT_INT_XINT2				= 254,
	BOOT_INT_XINT1				= 255,
	BOOT_INT_ADCC1				= 256,

	BOOT_INT_ADCA1				= 258,

	BOOT_SOC_INT_MAX,
} BOOT_IRQn_t;

#endif		/* end of (GS32F00xx == 0x3000) */

#ifdef __cplusplus
}
#endif

#endif
