/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_SYSCTL_V2_2_H__
#define __BOOT_SYSCTL_V2_2_H__

#ifdef __cplusplus
extern "C"{
#endif

#if ((GS32F3xx == 0x2200) ||(GS32F3xx == 0x2203))

#include "boot_hw_type.h"
#include "sysctl.h"

/**
 * @brief Enable/Disable HSE
 *
 * @param enable 0- disable, 1- enable
 */
BOOT_TEXT void boot_sysctl_set_hse_cmd_enable(uint32_t enable);

/**
 * CFG_CMD_ST_CLR  CMD_ST_CLR Enable offset 0x0054
 *
 * Register Field			Field Range
 * reserved					31 : 1
 * cfg_cmd_st_clr			0
 */
BOOT_TEXT void boot_sysctl_set_cmd_st_clr(uint32_t val);

BOOT_TEXT uint32_t boot_sysctl_get_cmd_st_clr(void);

/**
 * @brief CMD_CHECK_FAIL_RPT Command Detection Result Reporting offset 0x0058
 *
 * Register Field			Field Range
 * reserved					31 : 1
 * cmd_check_fail_rpt		0
 */
BOOT_TEXT uint32_t boot_sysctl_get_cmd_check_fail_rpt(void);

BOOT_TEXT void boot_sysctl_set_x1_cnt_clr(void);

BOOT_TEXT uint32_t boot_sysctl_get_x1_cnt(void);

/**
 * @brief CFG_DIV_APB_SYS APB Clock Division Configuration Register Offset 0x0018
 *
 * Register Field		Field Range
 * reserved				31 : 16
 * cfg_div_apb_sys		15 : 0
 */
BOOT_TEXT void boot_sysctl_set_apb_clock_div(crg_div_t value);

/**
 * @brief Configure the system clock divider.
 *
 * @param value system division value.
 */
BOOT_TEXT void boot_sysctl_set_dsp_sysclk_div(crg_div_t value);

/**
 * @brief CFG_DIV_PERI_SYS Peripheral Clock Division Configuration Register Offset 0x014
 *
 * Register Field		Field Range
 * reserved				31 : 16
 * cfg_div_dsp_peri		15 : 0
 */
BOOT_TEXT void boot_sysctl_set_periclk_div(crg_div_t value);

/**
 * @brief CFG_SYS_DIV_LOAD_POS Clock Division Configuration Synchronization Update Register Offset 0x001C
 *
 * Register Field				Field Range
 * reserved						31 : 1
 * cfg_sys_div_load_pos			0
 */
BOOT_TEXT void boot_sysctl_set_sys_div_Load(void);

/**
 * @brief SYSCLK_S2N_EN System Clock SLOW to NORMAL Switch Offset 0x0008
 *
 * Register Field		Field Range
 * reserved				31 : 1
 * sysclk_s2n_en		0
 */
BOOT_TEXT void boot_sysctl_set_sysclk_s2n_enable(uint32_t value);

/**
 * @brief Set the reference clock selection
 *
 * @param value reference clock selection (@RefClkType_t).
 */
BOOT_TEXT void boot_sysctl_set_ref_clk_sel(RefClkType_t value);

/**
 * @brief PLL_DISABLE_SSCG PLL Spread Spectrum Function Disable Configuration Offset 0x0234
 *
 * Register Field		Field Range
 * reserved				31 : 1
 * bpll_disable_sscg	0
 */
BOOT_TEXT void boot_sysctl_set_pll_disable_sscg(uint32_t value);

/**
 * @brief PLL_RESETPTR PLL Spread Spectrum Reset Pointer Offset 0x0230
 *
 * Register Field		Field Range
 * reserved				31 : 1
 * bpll_resetptr		0
 */
BOOT_TEXT void boot_sysctl_set_pll_reset_ptr(uint32_t value);

/**
 * @brief PLL_PD PLL Power Down Configuration Offset 0x0200
 *
 * Register Field			Field Range
 * reserved					31 : 1
 * bpll_pd					0
 */
BOOT_TEXT void boot_sysctl_set_pll_pd(uint32_t value);

/**
 * @brief PLL_FBDIV_CFG PLL Feedback Divider Configuration Offset 0x0210
 *
 * Register Field			Field Range
 * reserved					31 : 12
 * bpll_fbdiv_cfg			11 : 0
 */
BOOT_TEXT void boot_sysctl_set_pll_fb_div_cfg(uint32_t value);

/**
 * @brief PLL_FRAC_CFG PLL Fractional Configuration Offset 0x0214
 *
 * Register Field			Field Range
 * reserved					31 : 24
 * bpll_frac_cfg			23 : 0
 */
BOOT_TEXT void boot_sysctl_set_pll_frac_cfg(uint32_t value);

/**
 * @brief PLL_DIV_CFG  PLL Divider Configuration Offset 0x020C
 *
 * Register Field			Field Range
 * reserved					31 : 12
 * bpll_div_cfg				11 : 0
 *
 * [2:0]: POSTDIV1
 * [5:3]: POSTDIV2
 * [11:6]: REFDIV
 */
BOOT_TEXT void boot_sysctl_set_pll_div_cfg(uint32_t value);

/**
 * @brief PLL_DIVVAL  PLL Spread Spectrum DIVVAL Configuration Offset 0x021C
 *
 * Register Field		Field Range
 * reserved				31 : 6
 * bpll_divval			5  : 0
 */
BOOT_TEXT void boot_sysctl_set_pll_div_val(uint32_t value);

/**
 * @brief PLL_SPREAD PLL Spread Spectrum Configuration Offset 0x0220
 *
 * Register Field		Field Range
 * reserved				31 : 6
 * bpll_spread			5  : 0
 */
BOOT_TEXT void boot_sysctl_set_pll_spread(uint32_t value);

/**
 * @brief PLL_DOWNSPREAD PLL Down Spread Configuration Offset 0x0224
 *
 * Register Field			Field Range
 * reserved					31 : 1
 * bpll_downspread			0
 */
BOOT_TEXT void boot_sysctl_set_pll_down_spread(uint32_t value);

/**
 * @brief PLL_OTHPD_CFG  PLL Function Power Down Configuration Offset 0x0208
 *
 * Register Field			Field Range
 * reserved					31 : 5
 * bpll_othpd_cfg			4 : 0
 *
 * [0]: DACPD
 * [1]: DSMPD
 * [2]: FOUT4PHASEPD
 * [3]: FOUTPOSTIDVPD
 * [4]: FOUTVCOPD
 */
BOOT_TEXT void boot_sysctl_set_pll_othpd_cfg(uint32_t value);

/**
 * @brief PLL_LCK PLL Lock Status   Offset 0x0238
 *
 * Register Field			Field Range
 * reserved					31 : 1u
 * bpll_unlck_his			0
 */
BOOT_TEXT void boot_sysctl_clear_pll_unlck_his(void);

/**
 * @brief PLL_LCK PLL Lock Status Offset 0x023C
 *
 * Register Field			Field Range
 * reserved					31 : 1
 * pll_lck					0
 */
BOOT_TEXT uint32_t boot_sysctl_get_pll_lock(void);

/**
 * @brief OBS_SIG_DIV Observation Clock Divider Configuration Register Offset 0x006C
 *
 * Register Field			Field Range
 * reserved					31 : 7
 * obs_sig_div				6 : 0
 */
BOOT_TEXT void boot_sysctl_set_obs_sig_div(uint32_t value);

BOOT_TEXT void boot_sysctl_enable_io_mt48_49_56_57(void);

#endif	/* (GS32F00xx == 0x1200) */

#ifdef __cplusplus
}
#endif

#endif
