/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __FDP_RT_H__
#define __FDP_RT_H__

#if (GS32F00xx == 0x3000)

#if defined(FDP_RT_FW)

#include "boot_hw_type.h"
#include "fdp_rt_errno.h"

#define BOOT_FDP_RT_SEC				__attribute__((section(".boot_fdp_rt_section")))

#define FDP_RT_CMD_DETECT_DEV						0xE0
#define FDP_RT_CMD_ERASE							0xE1
#define FDP_RT_CMD_WRITE							0xE2
#define FDP_RT_CMD_CHECK							0xE3

#define FDP_RT_HOST									0xDA
#define FDP_RT_DEV									0xDB

#define FDP_RT_FRAME_SIZE							8U
#define FDP_RT_DATA_FRAME_SIZE						16U
#define FDP_RT_ADDR_ALINE							16U

#define FDP_RT_ACK_OK								0xAA55U
#define FDP_RT_ACK_ERROR							0x55AAU
#define FDP_RT_ACK_CONTINUE							0xE5FAU
#define FDP_RT_ACK_DETECT							0xAE

typedef struct {
	uint32_t apb_freq;
	uint32_t ahb_freq;
	uint32_t pll_freq;
	uint32_t sys_freq;
} fdp_rt_clk_priv_t;

typedef enum {
	FDP_RT_DEV_UART_V3		= 1,
} fdp_rt_dev_id_t;

typedef enum {
	FDP_RT_CMD_STAGE		= 1,
	FDP_RT_DATA_STAGE		= 2,
} fdp_rt_stage_t;

typedef struct {
	uint8_t *rxbuf;
	uint8_t *txbuf;
	uint8_t *cache_rxbuf;
	uint32_t cache_rxbuf_index;
	uint32_t txbuf_size;
	uint32_t rxbuf_size;
	uint32_t rx_get_index;
	uint32_t rx_put_index;
	uint32_t dev_id;
	uint32_t phase;
	uint32_t flash_mode;
	uintptr_t dest_address;
	void *clk_private_data;
	void *dev_private_data;
} fdp_rt_ops_t;

BOOT_FDP_RT_SEC int fdp_rt_init(fdp_rt_ops_t *ops);

BOOT_FDP_RT_SEC int fdp_rt_deinit(fdp_rt_ops_t *ops);

BOOT_FDP_RT_SEC int fdp_rt_read(fdp_rt_ops_t *ops);

BOOT_FDP_RT_SEC int fdp_rt_write(fdp_rt_ops_t *ops);

BOOT_FDP_RT_SEC int fdp_rt_schedule(fdp_rt_ops_t *ops);

#endif

#endif

#endif
