/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if (GS32F00xx == 0x1200)

#include "boot_asysctl_v1_2.h"

BOOT_TEXT void boot_sysctl_set_ldo_test_mode(uint32_t mode)
{
	HWREG(ANALOGSUBSYS_BASE + ANA_CFG_O_ANA_LDO_1V1_CFG) =
		(HWREG(ANALOGSUBSYS_BASE + ANA_CFG_O_ANA_LDO_1V1_CFG) & (~(0x3 << 5))) | (mode << 5);
}

BOOT_TEXT void boot_sysctl_set_ldo_chop_enable(uint32_t en)
{
	HWREG(ANALOGSUBSYS_BASE + ANA_CFG_O_ANA_LDO_1V1_CFG) =
		(HWREG(ANALOGSUBSYS_BASE + ANA_CFG_O_ANA_LDO_1V1_CFG) & (~(0x1 << 7))) | (en << 7);
}

BOOT_TEXT void boot_sysctl_set_ldo_1v2_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4200U);

	reg_val = HWREG(0x400CD308U);

	/* 0~4 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x1fU)) | (22U << 0);
	else
		reg_val = (reg_val & (~0x1fU)) | (trim_val & 0x1fU);

	HWREG(0x400CD308U) = reg_val;
}

BOOT_TEXT void boot_sysctl_set_ana_ldo_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4210U);

	reg_val = HWREG(0x400CD534U);

	/* 0~2 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x7U)) | (0U << 0);
	else
		reg_val = (reg_val & (~0x7U)) | (trim_val & 0x7U);

	HWREG(0x400CD534U) = reg_val;
}

void boot_sysctl_set_top_bor_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4208U);

	reg_val = HWREG(0x400CD304U);

	/* 6~4 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x70U));
	else
		reg_val = (reg_val & (~0x70U)) | (trim_val & 0x7U);

	HWREG(0x400CD304U) = reg_val;
}

BOOT_TEXT void boot_sysctl_set_osc1_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4230U);

	reg_val = HWREG(0x400CD314U);

	/* 0~14 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x7fffU)) | (0x0585U << 0);
	else
		reg_val = (reg_val & (~0x7fffU)) | (trim_val & 0x7fffU);

	HWREG(0x400CD314U) = reg_val;
}

BOOT_TEXT void boot_sysctl_set_osc2_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4230U);

	reg_val = HWREG(0x400CD314U);

	/* 16~30 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x7fff0000U)) | (0x05a1U << 16);
	else
		reg_val = (reg_val & (~0x7fff0000U)) | (trim_val & 0x7fff0000U);

	HWREG(0x400CD314U) = reg_val;
}

#endif	/* GS32F00xx */
