/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if ((GS32F3xx == 0x2200) ||(GS32F3xx == 0x2203))

#include "boot_asysctl_v2_2.h"

void boot_sysctl_set_ldo_1v1_test_mode(uint32_t mode)
{
	HWREG(ANALOGSUBSYS_BASE + ANA_CFG_O_ANA_LDO_1V1_CFG) =
		(HWREG(CRG_CFG_BASE + ANA_CFG_O_ANA_LDO_1V1_CFG) & (~(0x03 << 5))) | ((mode & 0x3) << 5);
}

void boot_sysctl_set_ldo_chop_enable(uint32_t enable)
{
	HWREG(ANALOGSUBSYS_BASE + ANA_CFG_O_ANA_LDO_1V1_CFG) =
		(HWREG(CRG_CFG_BASE + ANA_CFG_O_ANA_LDO_1V1_CFG) & (~(0x01 << 7))) | ((enable & 0x1) << 7);
}

void boot_sysctl_set_ldo_1v2_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF8210U);

	reg_val = HWREG(0x400CFF00U);

	/* 6~2 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~(0x1fU<<2))) | (22U << 2);
	else
		reg_val = (reg_val & (~(0x1fU<<2))) | ((trim_val & 0x1fU)<<2U);

	HWREG(0x400CFF00U) = reg_val;
}

void boot_sysctl_set_ana_ldo_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF8110U);

	reg_val = HWREG(0x400CD534U);

	/* 0~2 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x7U));
	else
		reg_val = (reg_val & (~0x7U)) | (trim_val & 0x7U);

	HWREG(0x400CD534U) = reg_val;
}

void boot_sysctl_set_top_bor_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF8218U);

	reg_val = HWREG(0x400CD304U);

	/* 6~4 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x70U));
	else
		reg_val = (reg_val & (~0x70U)) | (trim_val & 0x7U);

	HWREG(0x400CD304U) = reg_val;
}

void boot_sysctl_set_osc1_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF8120U);

	reg_val = HWREG(0x400CD314U);

	/* 14~0 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x7fffU));
	else
		reg_val = (reg_val & (~0x7fffU)) | (trim_val & 0x7fffU);

	HWREG(0x400CD314U) = reg_val;
}

void boot_sysctl_set_osc2_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF8120U);

	reg_val = HWREG(0x400CD314U);

	/* 30~16 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x7fff0000U));
	else
		reg_val = (reg_val & (~0x7fff0000U)) | (trim_val & 0x7fff0000U);

	HWREG(0x400CD314U) = reg_val;
}

#endif
