/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if (GS32F00xx == 0x1200)

#include "boot_flash_v1_2.h"

BOOT_FLASH_FUNC_SECTION uint32_t boot_flash_lock_status(uint32_t flashCtlBase)
{
	return HWREG(flashCtlBase + BOOT_FLASH_O_WRITE_PROTECT) & BOOT_FLASH_CONTROL_WRITE_PROTECT;
}

BOOT_FLASH_FUNC_SECTION static void boot_flash_lock_reg(uint32_t flashCtlBase)
{
	uint32_t u32FlashCtlValue = 0;

	/* disable write protect */
	HWREG(flashCtlBase + BOOT_FLASH_O_UNLOCK1) = BOOT_FLASH_UNLOCK_CODE1;
	HWREG(flashCtlBase + BOOT_FLASH_O_UNLOCK2) = BOOT_FLASH_UNLOCK_CODE2;
	HWREG(flashCtlBase + BOOT_FLASH_O_UNLOCK1) = BOOT_FLASH_UNLOCK_CODE3;

	/* clear write_protect bit */
	u32FlashCtlValue = HWREG(flashCtlBase + BOOT_FLASH_O_WRITE_PROTECT);
	u32FlashCtlValue |= BOOT_FLASH_CONTROL_WRITE_PROTECT;
	HWREG(flashCtlBase + BOOT_FLASH_O_WRITE_PROTECT) = u32FlashCtlValue;
}

BOOT_FLASH_FUNC_SECTION static void boot_flash_unlock_reg(uint32_t flashCtlBase)
{
	uint32_t u32FlashCtlValue = 0;

	/* disable write protect */
	HWREG(flashCtlBase + BOOT_FLASH_O_UNLOCK1) = BOOT_FLASH_UNLOCK_CODE1;
	HWREG(flashCtlBase + BOOT_FLASH_O_UNLOCK2) = BOOT_FLASH_UNLOCK_CODE2;
	HWREG(flashCtlBase + BOOT_FLASH_O_UNLOCK1) = BOOT_FLASH_UNLOCK_CODE3;

	/* clear write_protect bit */
	u32FlashCtlValue = HWREG(flashCtlBase + BOOT_FLASH_O_WRITE_PROTECT);
	u32FlashCtlValue &= ~BOOT_FLASH_CONTROL_WRITE_PROTECT;
	HWREG(flashCtlBase + BOOT_FLASH_O_WRITE_PROTECT) = u32FlashCtlValue;
}

BOOT_FLASH_FUNC_SECTION void boot_flash_lock_register(uint32_t flashCtlBase)
{
	boot_flash_lock_reg(flashCtlBase);
}

BOOT_FLASH_FUNC_SECTION void boot_flash_unlock_register(uint32_t flashCtlBase)
{
	boot_flash_unlock_reg(flashCtlBase);
}

BOOT_FLASH_FUNC_SECTION void boot_flash_wakeup_from_lpm(uint32_t flashCtlBase)
{
	HWREG(flashCtlBase + BOOT_FLASH_O_CONTROL) &= (~BOOT_FLASH_CONTROL_SLP_MODE);
}

BOOT_FLASH_FUNC_SECTION void boot_flash_set_read_wait_cycle(uint32_t flashCtlBase, uint32_t cycle_num)
{
	HWREG(flashCtlBase + BOOT_FLASH_O_TIMING0) = (HWREG(flashCtlBase + BOOT_FLASH_O_TIMING0) &
												(~BOOT_FLASH_TIMING0_TACC_CYCLES)) | cycle_num;
}

#endif		/* GS32F00xx */
