/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if (GS32F00xx == 0x3000)

#include "boot_sysctl_subcrg_peripheral_v3_0.h"

BOOT_TEXT void boot_sysctl_enable_peripheral(Boot_SysCtl_PeripheralPCLOCKCR_t peripheral)
{
	if(peripheral != BOOT_SYSCTL_PERIPH_CLK_TBCLKSYNC) {
		HWREG(SUB_CRG_BASE + ((peripheral>>BOOT_CRG_CFG_ADDR_SHIFT) & BOOT_CRG_CFG_ADDR_MASK)) |=
			((peripheral >> BOOT_CRG_CFG_MASK_SHIFT) & BOOT_CRG_CFG_MASK_MASK) << (peripheral & BOOT_CRG_CFG_OFF_MASK);
	} else {
		HWREG(AHB_COMM_PARA_BASE + AHB1_COMM_PARA_TBCLKSYNC) |= 1<<18;
	}
}

BOOT_TEXT void boot_sysctl_disable_peripheral(Boot_SysCtl_PeripheralPCLOCKCR_t peripheral)
{
	if(peripheral != BOOT_SYSCTL_PERIPH_CLK_TBCLKSYNC) {
		HWREG(SUB_CRG_BASE + ((peripheral>>BOOT_CRG_CFG_ADDR_SHIFT) & BOOT_CRG_CFG_ADDR_MASK)) &=
			~(((peripheral >> BOOT_CRG_CFG_MASK_SHIFT) & BOOT_CRG_CFG_MASK_MASK) << (peripheral & BOOT_CRG_CFG_OFF_MASK));
	} else {
		HWREG(AHB_COMM_PARA_BASE + AHB1_COMM_PARA_TBCLKSYNC) &= ~(1<<18);
	}
}

#endif
