/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if (GS32F00xx == 0x1200)

#include "boot_sysctl_v1_2.h"

void boot_sysctl_set_hse_cmd_enable(uint32_t enable)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_CMD_EN) = enable;
}

void boot_sysctl_set_cmd_st_clr(uint32_t val)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_CMD_ST_CLR) = val;
}

uint32_t boot_sysctl_get_cmd_st_clr(void)
{
	return HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_CMD_ST_CLR) & 0x01;
}

uint32_t boot_sysctl_get_cmd_check_fail_rpt(void)
{
	return HWREG(CRG_CFG_BASE + CRG_CFG_O_CMD_CHECK_FAIL_RPT) & 0x01;
}

/**
 * @brief X1_CNT X1 Clock Self-Test Register offset 0x70
 *
 * Register Field				Field Range
 * cfg_ref_pin_clk_cnt_clr		16
 * reserved						15 : 11
 * ref_pin_clk_cnt				10 : 0
 */
void boot_sysctl_set_x1_cnt_clr(void)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_X1_CNT) = 1<<16;
}

uint32_t boot_sysctl_get_x1_cnt(void)
{
	return HWREG(CRG_CFG_BASE + CRG_CFG_O_X1_CNT) & 0x7FF;
}

void boot_sysctl_set_apb_clock_div(crg_div_t value)
{
	if (value == CRG_DIV_2)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_APB_SYS) = 0x5555;
	else if (value == CRG_DIV_4)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_APB_SYS) = 0x1111;
	else if (value == CRG_DIV_8)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_APB_SYS) = 0x0101;
	else if (value == CRG_DIV_16)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_APB_SYS) = 0x0001;
	else
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_APB_SYS) = 0xFFFF;
}

void boot_sysctl_set_slave_sys_clk_div(crg_div_t value)
{
	if (value == CRG_DIV_2)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_SLV_SYS) = 0x5555;
	else if (value == CRG_DIV_4)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_SLV_SYS) = 0x1111;
	else if (value == CRG_DIV_8)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_SLV_SYS) = 0x0101;
	else
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_SLV_SYS) = 0xFFFF;
}

void boot_sysctl_set_dsp_sysclk_div(crg_div_t value)
{
	if (value == CRG_DIV_2)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_DSP_SYS) = 0x5555;
	else if (value == CRG_DIV_4)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_DSP_SYS) = 0x1111;
	else if (value == CRG_DIV_8)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_DSP_SYS) = 0x0101;
	else
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_DSP_SYS) = 0xFFFF;
}

void boot_sysctl_set_sys_div_Load(void)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_SYS_DIV_LOAD_POS) = 1;
}

void boot_sysctl_set_sysclk_s2n_enable(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_S2N_CLK_SEL) = value;
}

void boot_sysctl_set_ref_clk_sel(RefClkType_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_REF_CLK_SEL) = value;
}

void boot_sysctl_set_pll_disable_sscg(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_DISABLE_SSCG) = value ;
}

void boot_sysctl_set_pll_reset_ptr(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_RESETPTR) = value ;
}

void boot_sysctl_set_pll_pd(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_PD) = value ;
}

void boot_sysctl_set_pll_fb_div_cfg(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_FBDIV_CFG) = value ;
}

void boot_sysctl_set_pll_frac_cfg(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_FRAC_CFG) = value ;
}

void boot_sysctl_set_pll_div_cfg(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_DIV_CFG) = value ;
}

void boot_sysctl_set_pll_div_val(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_DIVVAL) = value ;
}

void boot_sysctl_set_pll_spread(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_SPREAD) = value ;
}

void boot_sysctl_set_pll_down_spread(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_DOWNSPREAD) = value ;
}

void boot_sysctl_set_pll_othpd_cfg(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_OTHPD_CFG) = value ;
}

void boot_sysctl_clear_pll_unlck_his(void)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_UNLCK) = 1;
}

uint32_t boot_sysctl_get_pll_lock(void)
{
	return HWREG(CRG_CFG_BASE + CRG_CFG_O_PLL_LCK) & 0x01;
}

void boot_sysctl_set_obs_sig_div(uint32_t value)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_OBS_SIG_DIV) = value;
}

#endif
