/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    cpu2_img.S
*   @brief
*
*/

#include "board_cfg.h"

#if (defined(LOAD_DSP_CPU2) && LOAD_DSP_CPU2 != 0) && !(defined (DSP_CPU2_RUN_IN_FLASH) &&  DSP_CPU2_RUN_IN_FLASH != 0)
#ifdef FLASH_TARGET
        .section .rom_data.dsp_img, "a"          //put image into flash
#else
        .section .sram_data.dsp_img          //put image into ram
#endif
        .align   4
        .global DspImageStartAddr
        .global DspImageEndAddr

DspImageStartAddr:
    #if LOAD_DSP_CPU2 == 1
    # if (GS32F3xx & 0xFF00) == 0x2200
        .incbin "../../37x_dualcore_cpu2/ILM/37x_dualcore_cpu2.img"
    # endif
    #endif
        //.balign 1
DspImageEndAddr:
    .byte 0

#endif
