/*
 * board.c
 *
 *  Created on: 2025 Jul 24
 *      Author: Gejian
 */

#include "board.h"

void Board_init()
{
//	ADC_init();
//	CMPSS_init();
//	PWM_init();
//	GPIO_init();
	Pinmux_init();
	CLBXBAR_init();
}

void ADC_init()
{
	SINADC_init();
	COSADC_init();
}

void SINADC_init()
{
	/*
	 * @brief ADC Initialization:
	 * 		  Write ADC configurations and power up the ADC.
	 */
	/* Select ADC Reference mode and Reference voltage */
	ADC_setVREF(SIN_ADC_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

	/* Set trim */
	ADC_setINLTrim(SIN_ADC_BASE);

	/* Configures the analog-to-digital converter module prescaler. */
	ADC_setPrescaler(SIN_ADC_BASE, ADC_CLK_DIV_4_0);

	/* Sets the timing of the end-of-conversion pulse */
	ADC_setInterruptPulseMode(SIN_ADC_BASE, ADC_PULSE_END_OF_CONV);

	/* Powers up the ADCA core. */
	ADC_enableConverter(SIN_ADC_BASE);

	/* Delay for 1ms to allow ADCA time to power up */
	DEVICE_DELAY_US(5000);

	/*
	 * @brief SOC Configuration:
	 * 		  Setup ADC EPWM channel and trigger settings.
	 */
	/* Disables SOC burst mode. */
	ADC_disableBurstMode(SIN_ADC_BASE);

	/* Sets the priority mode of the SOCs. */
	ADC_setSOCPriority(SIN_ADC_BASE, ADC_PRI_ALL_ROUND_ROBIN);

	/*
	 * @brief Start of Conversion 0 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 0
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(SIN_ADC_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN3, 20U);
	ADC_setInterruptSOCTrigger(SIN_ADC_BASE, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 1 Configuration
	 * 		Source	: ADC_INT_TRIGGER_EOC0
	 * 		Interrupt Source: enable
	 * 		Continuous Mode	: disabled
	 */
	ADC_setInterruptSource(SIN_ADC_BASE, ADC_INT_NUMBER1, ADC_INT_TRIGGER_EOC0);
	ADC_enableInterrupt(SIN_ADC_BASE, ADC_INT_NUMBER1);
	ADC_clearInterruptStatus(SIN_ADC_BASE, ADC_INT_NUMBER1);
	ADC_disableContinuousMode(SIN_ADC_BASE, ADC_INT_NUMBER1);

}
void COSADC_init()
{
	/*
	 * @brief ADC Initialization:
	 * 		  Write ADC configurations and power up the ADC.
	 */
	/* Select ADC Reference mode and Reference voltage */
	ADC_setVREF(COS_ADC_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

	/* Set trim */
	ADC_setINLTrim(COS_ADC_BASE);

	/* Configures the analog-to-digital converter module prescaler. */
	ADC_setPrescaler(COS_ADC_BASE, ADC_CLK_DIV_4_0);

	/* Sets the timing of the end-of-conversion pulse */
	ADC_setInterruptPulseMode(COS_ADC_BASE, ADC_PULSE_END_OF_CONV);

	/* Powers up the ADCA core. */
	ADC_enableConverter(COS_ADC_BASE);

	/* Delay for 1ms to allow ADCA time to power up */
	DEVICE_DELAY_US(5000);

	/*
	 * @brief SOC Configuration:
	 * 		  Setup ADC EPWM channel and trigger settings.
	 */
	/* Disables SOC burst mode. */
	ADC_disableBurstMode(COS_ADC_BASE);

	/* Sets the priority mode of the SOCs. */
	ADC_setSOCPriority(COS_ADC_BASE, ADC_PRI_ALL_ROUND_ROBIN);

	/*
	 * @brief Start of Conversion 0 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 0
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(COS_ADC_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN12, 20U);
	ADC_setInterruptSOCTrigger(COS_ADC_BASE, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 1 Configuration
	 * 		Source	: ADC_INT_TRIGGER_EOC0
	 * 		Interrupt Source: enable
	 * 		Continuous Mode	: disabled
	 */
	ADC_setInterruptSource(COS_ADC_BASE, ADC_INT_NUMBER1, ADC_INT_TRIGGER_EOC0);
	ADC_enableInterrupt(COS_ADC_BASE, ADC_INT_NUMBER1);
	ADC_clearInterruptStatus(COS_ADC_BASE, ADC_INT_NUMBER1);
	ADC_disableContinuousMode(COS_ADC_BASE, ADC_INT_NUMBER1);
}


void CMPSS_init()
{
	SINCMPSS_init();
	COSCMPSS_init();
}

void SINCMPSS_init()
{
    // Select the value for CMP1HPMXSEL.
    ASysCtl_selectCMPHPMux(ASYSCTL_CMPHPMUX_SELECT_1,0U);

    ASysCtl_selectCMPHNMuxValue(ASYSCTL_CMPHNMUX_SELECT_1,1U);

    // Sets the configuration for the high comparator.
    CMPSS_configHighComparator(SIN_CMPSS_BASE,(CMPSS_INSRC_PIN));

    //  Configures the digital filter of the high comparator.
    CMPSS_configFilterHigh(SIN_CMPSS_BASE, 0U, 10U, 6U);

    // Sets the output signal configuration for the high comparator.
    CMPSS_configOutputsHigh(SIN_CMPSS_BASE,(CMPSS_TRIPOUT_FILTER | CMPSS_TRIP_FILTER));

    // Sets the comparator hysteresis settings.
    CMPSS_setHysteresis(SIN_CMPSS_BASE,0U);

    // Disables reset of HIGH comparator digital filter output latch on PWMSYNC
    CMPSS_disableLatchResetOnPWMSYNCHigh(SIN_CMPSS_BASE);

    // Disables reset of LOW comparator digital filter output latch on PWMSYNC
    CMPSS_disableLatchResetOnPWMSYNCLow(SIN_CMPSS_BASE);

    // Sets the ePWM module blanking signal that holds trip in reset.
    CMPSS_configBlanking(SIN_CMPSS_BASE,1U);

    // Disables an ePWM blanking signal from holding trip in reset.
    CMPSS_disableBlanking(SIN_CMPSS_BASE);

    // Configures whether or not the digital filter latches are reset by PWMSYNC
    CMPSS_configLatchOnPWMSYNC(SIN_CMPSS_BASE,false,false);

    // Enables the CMPSS module.
    CMPSS_enableModule(SIN_CMPSS_BASE);

//    // Select the value for CMP1HPMXSEL.
//    ASysCtl_selectCMPHPMux(ASYSCTL_CMPHPMUX_SELECT_3,5U);
//
//    // Select the value for CMP1LPMXSEL.
//    ASysCtl_selectCMPLPMux(ASYSCTL_CMPLPMUX_SELECT_3,1U);
//
//    // Sets the configuration for the high comparator.
//    CMPSS_configHighComparator(SIN_CMPSS_BASE, CMPSS_INSRC_DAC | CMPSS_OR_ASYNC_OUT_W_FILT);
//
//    // Sets the configuration for the low comparator.
//    CMPSS_configLowComparator(SIN_CMPSS_BASE,(CMPSS_INSRC_DAC));
//
//    // Sets the configuration for the internal comparator DACs.
//    CMPSS_configDAC(SIN_CMPSS_BASE,(CMPSS_DACVAL_SYSCLK | CMPSS_DACREF_VDDA | CMPSS_DACSRC_SHDW));
//
//    // Sets the value of the internal DAC of the high comparator.
//    CMPSS_setDACValueHigh(SIN_CMPSS_BASE,3053U);
//
//    // Sets the value of the internal DAC of the low comparator.
//    CMPSS_setDACValueLow(SIN_CMPSS_BASE,3053U);
//
//    //  Configures the digital filter of the high comparator.
//    CMPSS_configFilterHigh(SIN_CMPSS_BASE, 0U, 32U, 31U);
//
//    // Configures the digital filter of the low comparator.
//    CMPSS_configFilterLow(SIN_CMPSS_BASE, 0U, 1U, 1U);
//
//    // Initializes the digital filter of the high comparator.
//    CMPSS_initFilterHigh(SIN_CMPSS_BASE);
//
//    // Sets the output signal configuration for the high comparator.
//    CMPSS_configOutputsHigh(SIN_CMPSS_BASE,(CMPSS_TRIPOUT_FILTER | CMPSS_TRIP_FILTER));
//
//    // Sets the output signal configuration for the low comparator.
//    CMPSS_configOutputsLow(SIN_CMPSS_BASE,(CMPSS_TRIPOUT_FILTER | CMPSS_TRIP_FILTER | CMPSS_INV_INVERTED));
//
//    // Sets the comparator hysteresis settings.
//    CMPSS_setHysteresis(SIN_CMPSS_BASE,0U);
//
//    // Configures the comparator subsystem's ramp generator.
//    CMPSS_configRamp(SIN_CMPSS_BASE,0U,0U,0U,1U,true);
//
//    // Disables reset of HIGH comparator digital filter output latch on PWMSYNC
//    CMPSS_disableLatchResetOnPWMSYNCHigh(SIN_CMPSS_BASE);
//
//    // Disables reset of LOW comparator digital filter output latch on PWMSYNC
//    CMPSS_disableLatchResetOnPWMSYNCLow(SIN_CMPSS_BASE);
//
//    // Sets the ePWM module blanking signal that holds trip in reset.
//    CMPSS_configBlanking(SIN_CMPSS_BASE,1U);
//
//    // Disables an ePWM blanking signal from holding trip in reset.
//    CMPSS_disableBlanking(SIN_CMPSS_BASE);
//
//    // Configures whether or not the digital filter latches are reset by PWMSYNC
//    CMPSS_configLatchOnPWMSYNC(SIN_CMPSS_BASE,false,false);
//
//    // Enables the CMPSS module.
//    CMPSS_enableModule(SIN_CMPSS_BASE);



}
void COSCMPSS_init()
{
    // Select the value for CMP1HPMXSEL.
    ASysCtl_selectCMPHPMux(ASYSCTL_CMPHPMUX_SELECT_2,0U);

    ASysCtl_selectCMPHNMuxValue(ASYSCTL_CMPHNMUX_SELECT_2,1U);

    // Sets the configuration for the high comparator.
    CMPSS_configHighComparator(COS_CMPSS_BASE,(CMPSS_INSRC_PIN));

    //  Configures the digital filter of the high comparator.
    CMPSS_configFilterHigh(COS_CMPSS_BASE, 0U, 10U, 6U);

    // Sets the output signal configuration for the high comparator.
    CMPSS_configOutputsHigh(COS_CMPSS_BASE,(CMPSS_TRIPOUT_FILTER | CMPSS_TRIP_FILTER));

    // Sets the comparator hysteresis settings.
    CMPSS_setHysteresis(COS_CMPSS_BASE,0U);

    // Disables reset of HIGH comparator digital filter output latch on PWMSYNC
    CMPSS_disableLatchResetOnPWMSYNCHigh(COS_CMPSS_BASE);

    // Disables reset of LOW comparator digital filter output latch on PWMSYNC
    CMPSS_disableLatchResetOnPWMSYNCLow(COS_CMPSS_BASE);

    // Sets the ePWM module blanking signal that holds trip in reset.
    CMPSS_configBlanking(COS_CMPSS_BASE,1U);

    // Disables an ePWM blanking signal from holding trip in reset.
    CMPSS_disableBlanking(COS_CMPSS_BASE);

    // Configures whether or not the digital filter latches are reset by PWMSYNC
    CMPSS_configLatchOnPWMSYNC(COS_CMPSS_BASE,false,false);

    // Enables the CMPSS module.
    CMPSS_enableModule(COS_CMPSS_BASE);
}

void PWM_init()
{
	uint16_t freq;

	freq = (uint16_t)(DEVICE_AHBCLK_FREQ / HPF_SAMPLERATE);
    /* Disable SOCA */
    EPWM_disableADCTrigger(myEPWM_BASE, EPWM_SOC_A);

    /* Configure the SOC to occur on the first up-count event */
    EPWM_setADCTriggerSource(myEPWM_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_U_CMPA);

    EPWM_setADCTriggerEventPrescale(myEPWM_BASE, EPWM_SOC_A, 1);

    EPWM_setCounterCompareValue(myEPWM_BASE, EPWM_COUNTER_COMPARE_A, freq/2);

    EPWM_setTimeBasePeriod(myEPWM_BASE, freq-1);

    /* Set the local ePWM module clock divider to /1 */
    EPWM_setClockPrescaler(myEPWM_BASE,
                           EPWM_CLOCK_DIVIDER_1,
                           EPWM_HSCLOCK_DIVIDER_1);

    /* Start ePWM1, enabling SOCA and putting the counter in up-count mode */
    EPWM_enableADCTrigger(EPWM1_BASE, EPWM_SOC_A);

    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP_DOWN);

    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

}

void GPIO_init()
{
	GPIO_enableWritePin(HPF_POWER_PIN);
	GPIO_writePin(HPF_POWER_PIN, 1);
}

void Pinmux_init()
{
	/* POWER GPIO15 */
	GPIO_setPinConfig(HPF_POWER_CONFIG);
	GPIO_setPadConfig(HPF_POWER_PIN, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(HPF_POWER_PIN, GPIO_QUAL_ASYNC);

	/* OUTPUTXBAR GPIO7 TXEN	 */
//	GPIO_setPinConfig(GPIO_7_CLB_OUTPUTXBAR2);
	GPIO_setPinConfig(GPIO_34_OUTPUTXBAR1);

	/* UART TX GPIO9 */
	GPIO_setPinConfig(HPF_UART_TX_CONFIG);
	GPIO_setPadConfig(HPF_UART_TX, GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(HPF_UART_TX, GPIO_QUAL_ASYNC);

	/* UART RX GPIO13 */
	GPIO_setAnalogMode(13, GPIO_ANALOG_DISABLED);
	GPIO_setPinConfig(HPF_UART_RX_CONFIG);
	GPIO_setPadConfig(HPF_UART_RX, GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(HPF_UART_RX, GPIO_QUAL_ASYNC);

//	/**
//	 * cmpss out
//	 */
//	GPIO_setPinConfig(GPIO_4_OUTPUTXBAR3);
//	GPIO_setPadConfig(4, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(4, GPIO_QUAL_ASYNC);
//
//	/**
//	 * cmpss out
//	 */
//	GPIO_setPinConfig(GPIO_6_OUTPUTXBAR4);
//	GPIO_setPadConfig(6, GPIO_PIN_TYPE_STD);
//	GPIO_setQualificationMode(6, GPIO_QUAL_ASYNC);

	/**
	 * Set Analog Pinmux
	 */
	/**
	 * ADCA SIN channel A3/C7/B9
	 */
	GPIO_setPinConfig(GPIO_244_GPIO244);
	GPIO_setAnalogMode(244, GPIO_ANALOG_ENABLED);
	/**
	 * Analog PinMux for A2/B6/C9
	 * SIN CMPSS P channel
	 */
	GPIO_setPinConfig(GPIO_224_GPIO224);
	GPIO_setAnalogMode(224, GPIO_ANALOG_ENABLED);
	/**
	 * Analog PinMux for A4/B8
	 * COS CMPSS P channel
	 */
	GPIO_setPinConfig(GPIO_225_GPIO225);
	GPIO_setAnalogMode(225, GPIO_ANALOG_ENABLED);
	/**
	 * Analog PinMux for A11/B10/C0
	 * SIN CMPSS N channel
	 */
	GPIO_setPinConfig(GPIO_237_GPIO237);
	GPIO_setAnalogMode(237, GPIO_ANALOG_ENABLED);
	/**
	 * Analog PinMux for C1
	 * COS CMPSS N channel
	 */
	GPIO_setPinConfig(GPIO_238_GPIO238);
	GPIO_setAnalogMode(238, GPIO_ANALOG_ENABLED);

}

void CLBXBAR_init()
{
	/* TXEN XBAR */
//    XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_OUT_MUX00_CLB1_OUT1 );
//    XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE ,XBAR_OUTPUT2,XBAR_MUX00);

//	XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 14);
//	XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 15);

    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_OUT_MUX01_CLB1_OUT1 );
    XBAR_enableOutputMux(OUTPUTXBAR_BASE ,XBAR_OUTPUT1,XBAR_MUX01);

    /* clb xbar0 is CMPSS1_CTRIPH */
    XBAR_setCLBMuxConfig(XBAR_AUXSIG0,XBAR_CLB_MUX00_CMPSS1_CTRIPH);
    XBAR_enableClbMux(XBAR_AUXSIG0, XBAR_MUX00);

    /* clb xbar1 is CMPSS2_CTRIPH */
    XBAR_setCLBMuxConfig(XBAR_AUXSIG1,XBAR_CLB_MUX02_CMPSS2_CTRIPH);
    XBAR_enableClbMux(XBAR_AUXSIG1, XBAR_MUX02);

	/**
	 * cmpss1 out
	 */
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT3, XBAR_OUT_MUX00_CMPSS1_CTRIPOUTH);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT3, XBAR_MUX00);

	/**
	 * cmpss2 out
	 */
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT4, XBAR_OUT_MUX02_CMPSS2_CTRIPOUTH);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT4, XBAR_MUX02);

}
