/*
 * board.h
 *
 *  Created on: 2025 Jul 24
 *      Author: Gejian
 */

#ifndef BOARD_H_
#define BOARD_H_

#include "device.h"
#include "board_cfg.h"

#define HPF_POWER_PIN	33
#define HPF_POWER_CONFIG	GPIO_33_GPIO33

#define HPF_UART_TX		9
#define HPF_UART_RX		13

#define HPF_UART_TX_CONFIG	GPIO_9_SCIB_TX
#define HPF_UART_RX_CONFIG	GPIO_13_SCIB_RX

#define SIN_ADC_BASE	ADCA_BASE
#define COS_ADC_BASE	ADCB_BASE

void SINADC_init();
void COSADC_init();

#define SIN_CMPSS_BASE	CMPSS3_BASE
#define COS_CMPSS_BASE	CMPSS2_BASE

void SINCMPSS_init();
void COSCMPSS_init();

#define myEPWM_BASE	EPWM1_BASE

#define HPF_SAMPLERATE	1600000	/* Hz*/

void Board_init();

void ADC_init();

void CMPSS_init();

void PWM_init();

void GPIO_init();

void Pinmux_init();

void CLBXBAR_init();


#endif /* BOARD_H_ */
